/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.forge.compat.touhou_little_maid.task;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.forge.compat.touhou_little_maid.MemoryTypeRegister;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.AutoPlayer;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.item.ItemDataUtils;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PlayMinoTask
extends MaidCheckRateTask {
    private CardPlayer cardPlayer;
    private final AutoPlayer autoPlayer = new AutoPlayer();

    public PlayMinoTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.autoPlayer.aiForgetChance = 0.0f;
    }

    protected void start(@NotNull ServerLevel level, EntityMaid maid, long gameTimeIn) {
        maid.m_6274_().m_21952_(MemoryTypeRegister.TARGET_POS.get()).ifPresent(targetPos -> {
            BlockPos tablePos = targetPos.m_6675_();
            BlockState tableState = level.m_8055_(tablePos);
            if (tableState.m_60713_(Mino.BLOCK_MINO_TABLE.get())) {
                BlockPos corePos = BlockMinoTable.getCore(tableState, tablePos);
                BlockEntity blockEntity = level.m_7702_(corePos);
                if (blockEntity instanceof BlockEntityMinoTable) {
                    CardPlayer cardPlayer;
                    BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
                    if (tableEntity.game != null) {
                        this.inGameLogic(tableEntity, maid);
                        return;
                    }
                    String model = maid.getModelId().split(":")[1];
                    String playerName = maid.m_8077_() ? maid.m_7770_().getString() : model;
                    this.cardPlayer = cardPlayer = new CardPlayer(maid.m_20148_(), playerName);
                    ItemStack handStack = new ItemStack((ItemLike)Mino.ITEM_HAND_CARDS.get());
                    ItemDataUtils.setCardGameBinding(handStack, corePos, cardPlayer.uuid);
                    maid.m_21008_(InteractionHand.MAIN_HAND, handStack);
                    tableEntity.joinPlayerToTable(cardPlayer, maid.m_20182_());
                }
            } else {
                maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                maid.m_8127_();
                this.cardPlayer = null;
            }
        });
    }

    private void inGameLogic(BlockEntityMinoTable tableEntity, EntityMaid maid) {
        if (tableEntity.game != null && tableEntity.game.players.get(tableEntity.game.currentPlayerIndex).equals(this.cardPlayer)) {
            CardPlayer realPlayer = tableEntity.game.deAmputate(this.cardPlayer);
            ActionReport result = this.autoPlayer.playAtGame(tableEntity.game, realPlayer, maid.m_20194_());
            tableEntity.handleActionResult(result, realPlayer, null);
        }
    }
}

