/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.forge.compat.touhou_little_maid.task;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.forge.compat.touhou_little_maid.MemoryTypeRegister;
import cn.zbx1425.minopp.forge.compat.touhou_little_maid.PoiRegistry;
import cn.zbx1425.minopp.forge.compat.touhou_little_maid.entity.MaidEntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FindMinoTask
extends MaidCheckRateTask {
    public static final String MinoTable = "mino_table";
    float speed;
    int closeEnoughDist;

    public FindMinoTask(float movementSpeed, int closeEnoughDist) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.closeEnoughDist = closeEnoughDist;
        this.speed = movementSpeed;
        this.setMaxCheckRate(10);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving() && (maid.m_21205_().m_41619_() || maid.m_21205_().m_150930_((Item)Mino.ITEM_HAND_CARDS.get()))) {
            BlockPos seatPos = this.findSeat(worldIn, maid);
            if (seatPos != null && maid.m_21444_(seatPos)) {
                if (seatPos.m_203193_((Position)maid.m_20182_()) < Math.pow(this.closeEnoughDist, 2.0)) {
                    maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(seatPos));
                    return true;
                }
                BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)seatPos, (float)this.speed, (int)1);
                this.setNextCheckTickCount(5);
            } else {
                maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
            }
        }
        return false;
    }

    protected void start(@NotNull ServerLevel level, EntityMaid maid, long gameTimeIn) {
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(targetPos -> {
            BlockPos pos = targetPos.m_6675_();
            BlockState blockState = level.m_8055_(pos);
            Block patt0$temp = blockState.m_60734_();
            if (patt0$temp instanceof BlockMinoTable) {
                BlockMinoTable minoTable = (BlockMinoTable)patt0$temp;
                this.startMaidSit(maid, blockState, (Level)level, pos);
                maid.m_6274_().m_21879_(MemoryTypeRegister.TARGET_POS.get(), targetPos);
            }
        });
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    @Nullable
    private BlockPos findSeat(ServerLevel world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PoiManager poiManager = world.m_8904_();
        int range = (int)maid.m_21535_();
        return poiManager.m_27181_(type -> ((PoiType)type.m_203334_()).equals(PoiRegistry.MINO_TABLE.get()), blockPos, range, PoiManager.Occupancy.ANY).map(poiRecord -> {
            BlockPos pos = poiRecord.m_27257_();
            BlockState state = world.m_8055_(pos);
            return BlockMinoTable.getCore(state, pos);
        }).filter(pos -> !this.isOccupied(world, (BlockPos)pos)).min(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)maid.m_20183_()))).orElse(null);
    }

    public void startMaidSit(EntityMaid maid, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            BlockEntityMinoTable minoTable;
            List<Direction> emptyDirections;
            ServerLevel serverLevel = (ServerLevel)worldIn;
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof BlockEntityMinoTable && !(emptyDirections = (minoTable = (BlockEntityMinoTable)blockEntity).getEmptyDirections()).isEmpty()) {
                Random random = new Random();
                Direction direction = emptyDirections.get(random.nextInt(emptyDirections.size()));
                Vec3i position = direction.m_122436_().m_142393_(2).m_7918_(1, 0, 1);
                MaidEntitySit newSitEntity = new MaidEntitySit(worldIn, Vec3.m_272021_((Vec3i)pos, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_()), MinoTable, pos.m_7918_(1, 0, 1));
                newSitEntity.m_146922_(direction.m_122424_().m_122435_());
                worldIn.m_7967_((Entity)newSitEntity);
                minoTable.m_6596_();
                maid.m_20329_((Entity)newSitEntity);
            }
        }
    }

    private boolean isOccupied(ServerLevel level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityMinoTable) {
            BlockEntityMinoTable minoTable = (BlockEntityMinoTable)blockEntity;
            return minoTable.getPlayersList().size() >= 4;
        }
        return true;
    }
}

