/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.entity;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.AutoPlayer;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.gui.AutoPlayerScreen;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.network.S2CAutoPlayerScreenPacket;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityAutoPlayer
extends LivingEntity {
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public CardPlayer cardPlayer;
    public BlockPos tablePos = null;
    private boolean noPush;
    private long lastTickGameTime = 0L;
    private boolean isThinking = false;
    private long thinkingFinishTime = 0L;
    private long gameEndTime = 0L;
    public final AutoPlayer autoPlayer = new AutoPlayer();
    public Optional<GameProfile> clientSkinGameProfile = Optional.empty();
    public String clientSkinGameProfileValidFor = "";
    private static final EntityDataAccessor<ItemStack> HAND_STACK = SynchedEntityData.m_135353_(EntityAutoPlayer.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(EntityAutoPlayer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> SKIN = SynchedEntityData.m_135353_(EntityAutoPlayer.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public EntityAutoPlayer(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.clientSkinGameProfileValidFor.equals(this.f_19804_.m_135370_(SKIN))) {
                this.clientSkinGameProfileValidFor = (String)this.f_19804_.m_135370_(SKIN);
                if (this.clientSkinGameProfileValidFor.isEmpty()) {
                    this.clientSkinGameProfile = Optional.empty();
                    return;
                }
                try {
                    UUID skinAsUUID = UUID.fromString(this.clientSkinGameProfileValidFor);
                    GameProfile profile = new GameProfile(skinAsUUID, null);
                    SkullBlockEntity.m_155738_((GameProfile)profile, profileNew -> {
                        this.clientSkinGameProfile = Optional.of(profileNew);
                    });
                }
                catch (IllegalArgumentException e) {
                    GameProfile profile = new GameProfile(null, this.clientSkinGameProfileValidFor);
                    SkullBlockEntity.m_155738_((GameProfile)profile, profileNew -> {
                        this.clientSkinGameProfile = Optional.of(profileNew);
                    });
                }
            }
            return;
        }
        if (!this.getActive()) {
            this.tablePos = null;
            this.m_5634_(10.0f);
            return;
        }
        if (this.autoPlayer.aiNoDelay < 2 && this.m_9236_().m_46467_() - this.lastTickGameTime < 10L) {
            return;
        }
        this.lastTickGameTime = this.m_9236_().m_46467_();
        if (this.tablePos == null) {
            boolean tableFound = false;
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos tobeTablePos = this.m_20183_().m_7918_(dx, 0, dz);
                        BlockState tobeTableState = this.m_9236_().m_8055_(tobeTablePos);
                        if (!tobeTableState.m_60713_(Mino.BLOCK_MINO_TABLE.get())) continue;
                        BlockPos corePos = BlockMinoTable.getCore(tobeTableState, tobeTablePos);
                        BlockEntity blockEntity = this.m_9236_().m_7702_(corePos);
                        if (!(blockEntity instanceof BlockEntityMinoTable)) continue;
                        BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
                        if (tableEntity.game != null) continue;
                        String playerName = this.m_8077_() ? this.m_7770_().getString() : "MinoBot #" + new Random().nextInt(100, 1000);
                        this.cardPlayer = new CardPlayer(this.f_19820_, playerName);
                        tableEntity.joinPlayerToTable(this.cardPlayer, this.m_20182_());
                        this.tablePos = corePos;
                        tableFound = true;
                        ItemStack handStack = new ItemStack((ItemLike)Mino.ITEM_HAND_CARDS.get());
                        ItemHandCards.setCardGameBinding(handStack, this.tablePos, this.cardPlayer.uuid);
                        this.f_19804_.m_135381_(HAND_STACK, (Object)handStack);
                        break;
                    }
                    if (tableFound) break;
                }
                if (tableFound) break;
            }
            if (!tableFound) {
                this.setActive(false);
                return;
            }
        }
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_272021_((Vec3i)this.tablePos, (double)1.0, (double)1.0, (double)1.0));
        BlockEntity blockEntity = this.m_9236_().m_7702_(this.tablePos);
        if (blockEntity instanceof BlockEntityMinoTable) {
            BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
            if (tableEntity.game != null) {
                this.m_5634_(10.0f);
                if (tableEntity.game.players.get(tableEntity.game.currentPlayerIndex).equals(this.cardPlayer)) {
                    if (this.autoPlayer.aiNoDelay > 0) {
                        this.isThinking = false;
                    } else {
                        if (!this.isThinking) {
                            this.thinkingFinishTime = tableEntity.game.currentPlayerPhase == CardGame.PlayerActionPhase.DISCARD_DRAWN ? this.m_9236_().m_46467_() + (long)new Random().nextInt(10, 20) : this.m_9236_().m_46467_() + (long)new Random().nextInt(10, 50);
                            this.isThinking = true;
                            return;
                        }
                        if (this.m_9236_().m_46467_() >= this.thinkingFinishTime) {
                            this.isThinking = false;
                        } else {
                            return;
                        }
                    }
                    CardPlayer realPlayer = tableEntity.game.deAmputate(this.cardPlayer);
                    ActionReport result = this.autoPlayer.playAtGame(tableEntity.game, realPlayer, this.m_20194_());
                    tableEntity.handleActionResult(result, realPlayer, null);
                    this.gameEndTime = -1L;
                } else {
                    this.isThinking = false;
                }
            } else {
                if (this.gameEndTime == -1L) {
                    this.gameEndTime = this.m_9236_().m_46467_() + 100L;
                } else if (this.m_9236_().m_46467_() - this.gameEndTime <= 60L) {
                    if (this.m_20096_()) {
                        this.m_6135_();
                    }
                } else if (this.autoPlayer.aiStartGame && tableEntity.getPlayersList().size() >= 2) {
                    tableEntity.startGame(this.cardPlayer);
                }
                if (!tableEntity.getPlayersList().stream().anyMatch(p -> p.equals(this.cardPlayer))) {
                    this.cardPlayer = null;
                    this.f_19804_.m_135381_(HAND_STACK, (Object)ItemStack.f_41583_);
                    this.tablePos = null;
                }
            }
        } else {
            this.cardPlayer = null;
            this.f_19804_.m_135381_(HAND_STACK, (Object)ItemStack.f_41583_);
            this.tablePos = null;
        }
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            if (player.m_20310_(2) && player.m_6144_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.getActive() && !player.m_6144_()) {
                return InteractionResult.SUCCESS;
            }
        } else {
            if (player.m_20310_(2) && player.m_6144_()) {
                S2CAutoPlayerScreenPacket.sendS2C((ServerPlayer)player, this);
                return InteractionResult.SUCCESS;
            }
            if (!this.getActive() && !player.m_6144_()) {
                this.setActive(true);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6096_(player, hand);
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    @NotNull
    public Iterable<ItemStack> m_6167_() {
        return List.of((ItemStack)this.f_19804_.m_135370_(HAND_STACK), ItemStack.f_41583_);
    }

    @NotNull
    public ItemStack m_6844_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return (ItemStack)this.f_19804_.m_135370_(HAND_STACK);
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return this.m_213877_() || !source.m_269533_(DamageTypeTags.f_268738_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.tablePos != null) {
            compound.m_128356_("TablePos", this.tablePos.m_121878_());
        }
        if (this.cardPlayer != null) {
            compound.m_128365_("CardPlayer", (Tag)this.cardPlayer.toTag());
        }
        if (!((ItemStack)this.f_19804_.m_135370_(HAND_STACK)).m_41619_()) {
            compound.m_128365_("HandStack", (Tag)((ItemStack)this.f_19804_.m_135370_(HAND_STACK)).m_41739_(new CompoundTag()));
        }
        this.writeConfigToTag(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.tablePos = compound.m_128425_("TablePos", 4) ? BlockPos.m_122022_((long)compound.m_128454_("TablePos")) : null;
        this.cardPlayer = compound.m_128425_("CardPlayer", 10) ? new CardPlayer(compound.m_128469_("CardPlayer")) : null;
        this.readConfigFromTag(compound);
        if (this.tablePos != null && this.cardPlayer != null) {
            ItemStack handStack = new ItemStack((ItemLike)Mino.ITEM_HAND_CARDS.get());
            ItemHandCards.setCardGameBinding(handStack, this.tablePos, this.cardPlayer.uuid);
            this.f_19804_.m_135381_(HAND_STACK, (Object)handStack);
        } else {
            this.f_19804_.m_135381_(HAND_STACK, (Object)ItemStack.f_41583_);
        }
    }

    public boolean m_6094_() {
        return !this.noPush;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAND_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(SKIN, (Object)"");
    }

    public static AttributeSupplier createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    public boolean getActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public boolean getNoPush() {
        return this.noPush;
    }

    public void setNoPush(boolean noPush) {
        this.noPush = noPush;
    }

    public String getSkin() {
        return (String)this.f_19804_.m_135370_(SKIN);
    }

    public void setSkin(String skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public CompoundTag writeConfigToTag() {
        CompoundTag tag = new CompoundTag();
        this.writeConfigToTag(tag);
        return tag;
    }

    public void writeConfigToTag(CompoundTag tag) {
        tag.m_128379_("Active", this.getActive());
        tag.m_128379_("NoPush", this.getNoPush());
        tag.m_128359_("Skin", this.getSkin());
        tag.m_128365_("AI", (Tag)this.autoPlayer.toConfigNbt());
        Component component = this.m_7770_();
        if (component != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)component));
        }
    }

    public void readConfigFromTag(CompoundTag tag) {
        this.setActive(tag.m_128471_("Active"));
        this.setNoPush(tag.m_128471_("NoPush"));
        this.setSkin(tag.m_128461_("Skin"));
        this.autoPlayer.useConfigNbt(tag.m_128469_("AI"));
        if (tag.m_128425_("CustomName", 8)) {
            try {
                this.m_6593_((Component)Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class Client {
        private Client() {
        }

        public static void openAutoPlayerScreen(EntityAutoPlayer autoPlayer) {
            Minecraft.m_91087_().m_91152_(AutoPlayerScreen.create(autoPlayer, Minecraft.m_91087_().f_91080_));
        }
    }
}

