/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.effect;

import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.effect.EffectEvent;
import cn.zbx1425.minopp.effect.EffectEvents;
import cn.zbx1425.minopp.gui.TurnDeadMan;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public record SoundEffectEvent(int timeOffset, Optional<UUID> target, SoundEvent sound) implements EffectEvent
{
    public static final EffectEvent.Serializer<SoundEffectEvent> SERIALIZER = new EffectEvent.Serializer<SoundEffectEvent>(){

        @Override
        public void serialize(FriendlyByteBuf buf, SoundEffectEvent event) {
            buf.writeInt(event.timeOffset);
            buf.m_236835_(event.target, FriendlyByteBuf::m_130077_);
            buf.m_130085_(event.sound.m_11660_());
        }

        @Override
        public SoundEffectEvent deserialize(FriendlyByteBuf buf) {
            int timeOffset = buf.readInt();
            Optional target = buf.m_236860_(FriendlyByteBuf::m_130259_);
            SoundEvent sound = SoundEvent.m_262856_((ResourceLocation)buf.m_130281_(), (float)16.0f);
            return new SoundEffectEvent(timeOffset, target, sound);
        }
    };

    public EffectEvent.Type<SoundEffectEvent> type() {
        return EffectEvents.SOUND;
    }

    @Override
    public void summonClient(Level level, BlockPos origin, boolean selfPartOfSourceGame) {
        level.m_245747_(origin, this.sound, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        if (selfPartOfSourceGame) {
            TurnDeadMan.pedal();
        }
    }

    @Override
    public void summonServer(ServerLevel level, BlockPos origin, BlockEntityMinoTable tableEntity) {
    }
}

