/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.effect;

import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.effect.EffectEvent;
import cn.zbx1425.minopp.effect.EffectEvents;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record PlayerFireworkEffectEvent(int timeOffset, UUID targetPlayer, CompoundTag firework) implements EffectEvent
{
    public static final EffectEvent.Serializer<PlayerFireworkEffectEvent> SERIALIZER = new EffectEvent.Serializer<PlayerFireworkEffectEvent>(){

        @Override
        public void serialize(FriendlyByteBuf buf, PlayerFireworkEffectEvent event) {
            buf.writeInt(event.timeOffset);
            buf.m_130077_(event.targetPlayer);
            buf.m_130079_(event.firework);
        }

        @Override
        public PlayerFireworkEffectEvent deserialize(FriendlyByteBuf buf) {
            int timeOffset = buf.readInt();
            UUID targetPlayer = buf.m_130259_();
            CompoundTag firework = buf.m_130260_();
            return new PlayerFireworkEffectEvent(timeOffset, targetPlayer, firework);
        }
    };
    public static final CompoundTag WIN_EXPLOSION;

    @Override
    public Optional<UUID> target() {
        return Optional.empty();
    }

    public EffectEvent.Type<PlayerFireworkEffectEvent> type() {
        return EffectEvents.PLAYER_FIREWORK;
    }

    @Override
    public void summonClient(Level level, BlockPos origin, boolean selfPartOfSourceGame) {
        Player player = level.m_46003_(this.targetPlayer);
        if (player != null) {
            level.m_7228_(player.m_20185_(), player.m_20186_() + 3.0, player.m_20189_(), 0.0, 0.0, 0.0, this.firework);
            return;
        }
        List entities = level.m_6249_((Entity)null, AABB.m_165882_((Vec3)Vec3.m_82528_((Vec3i)origin), (double)8.0, (double)8.0, (double)4.0), it -> it.m_20148_().equals(this.targetPlayer));
        if (!entities.isEmpty()) {
            Entity entity = (Entity)entities.get(0);
            level.m_7228_(entity.m_20185_(), entity.m_20186_() + 3.0, entity.m_20189_(), 0.0, 0.0, 0.0, this.firework);
            return;
        }
        level.m_7228_((double)((float)origin.m_123341_() + 0.5f), (double)(origin.m_123342_() + 3), (double)((float)origin.m_123343_() + 0.5f), 0.0, 0.0, 0.0, this.firework);
    }

    @Override
    public void summonServer(ServerLevel level, BlockPos origin, BlockEntityMinoTable tableEntity) {
    }

    static {
        try {
            WIN_EXPLOSION = TagParser.m_129359_((String)"{Explosions:[{Type:0,Colors:[I;13840175,16011550],FadeColors:[I;15702682,16755601],Trail:0,Flicker:0},{Type:1,Colors:[I;16635957,12634675],FadeColors:[I;16774557,15134364],Trail:0,Flicker:0}]}");
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

