/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.youkaishomecoming;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.entity.passive.IMaidsoulKitchenMaid;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.util.FakePlayerUtil;
import com.github.wallev.verhelper.server.item.VItemStack;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.item.fluid.IYHSake;
import dev.xkmc.youkaishomecoming.content.item.fluid.SakeBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.SakeFluid;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationDummyContainer;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationItemContainer;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationRecipe;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationTankBlock;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationTankBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.ferment.SimpleFermentationRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class TaskYhcFermentationTank
implements ICookTask<FermentationTankBlockEntity, FermentationRecipe<?>> {
    protected static final Map<SimpleFermentationRecipe, MaidFermentationRecipe> FERMENTATION_RECIPE_INGREDIENTS = new HashMap<SimpleFermentationRecipe, MaidFermentationRecipe>();
    protected static final Map<Fluid, List<ItemStack>> FLUID_CONTAINERS = new HashMap<Fluid, List<ItemStack>>();

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return DataRegister.YHC_FERMENTATION_TANK;
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof FermentationTankBlockEntity;
    }

    @Override
    public RecipeType<FermentationRecipe<?>> getRecipeType() {
        return (RecipeType)YHBlocks.FERMENT_RT.get();
    }

    @Override
    public MaidRecipesManager<FermentationRecipe<?>> getRecipesManager(EntityMaid maid) {
        return new MaidRecipesManager<FermentationRecipe<?>>(maid, this, true){

            @Override
            protected Pair<List<Integer>, List<Item>> getAmountIngredient(FermentationRecipe<?> recipe, Map<Item, Integer> available) {
                boolean hasIngredient;
                MaidFermentationRecipe maidKettleRecipe = FERMENTATION_RECIPE_INGREDIENTS.get((SimpleFermentationRecipe)recipe);
                ArrayList<Item> invIngredient = new ArrayList<Item>();
                HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
                boolean hasFluidItem = false;
                int fluidItemAmount = 0;
                Item fluidItem = ItemStack.f_41583_.m_41720_();
                for (ItemStack itemStack : maidKettleRecipe.inFluids()) {
                    hasIngredient = false;
                    for (Item item : available.keySet()) {
                        if (!itemStack.m_150930_(item) || available.get(item) < itemStack.m_41613_()) continue;
                        invIngredient.add(item);
                        hasIngredient = true;
                        if (item.m_41459_() == 1) {
                            itemTimes.put(item, 1);
                        } else {
                            itemTimes.merge(item, 1, Integer::sum);
                        }
                        fluidItemAmount = itemStack.m_41613_();
                        fluidItem = item;
                        break;
                    }
                    if (!hasIngredient) continue;
                    hasFluidItem = true;
                    break;
                }
                if (!maidKettleRecipe.inFluids().isEmpty() && !hasFluidItem) {
                    return Pair.of(Collections.emptyList(), Collections.emptyList());
                }
                for (Ingredient ingredient : maidKettleRecipe.inItems()) {
                    hasIngredient = false;
                    for (Item item : available.keySet()) {
                        ItemStack stack = item.m_7968_();
                        if (!ingredient.test(stack)) continue;
                        invIngredient.add(item);
                        hasIngredient = true;
                        if (stack.m_41741_() == 1) {
                            itemTimes.put(item, 1);
                            break;
                        }
                        itemTimes.merge(item, 1, Integer::sum);
                        break;
                    }
                    if (hasIngredient) continue;
                    return Pair.of(Collections.emptyList(), Collections.emptyList());
                }
                if (itemTimes.entrySet().stream().anyMatch(entry -> (Integer)available.get(entry.getKey()) < (Integer)entry.getValue())) {
                    return Pair.of(Collections.emptyList(), Collections.emptyList());
                }
                int maxCount = 1;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (!maidKettleRecipe.inFluids().isEmpty()) {
                    arrayList.add(0, fluidItemAmount);
                    available.put(fluidItem, available.get(fluidItem) - fluidItemAmount);
                } else {
                    arrayList.add(0, 0);
                    invIngredient.add(0, ItemStack.f_41583_.m_41720_());
                }
                for (Item item : invIngredient.stream().skip(1L).toList()) {
                    arrayList.add(maxCount);
                    available.put(item, available.get(item) - maxCount);
                }
                return Pair.of(arrayList, invIngredient);
            }
        };
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, FermentationTankBlockEntity blockEntity, MaidRecipesManager<FermentationRecipe<?>> recManager) {
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        FermentationDummyContainer cont = new FermentationDummyContainer(blockEntity.items, blockEntity.fluids);
        Optional beRecipe = maid.f_19853_.m_7465_().m_44015_((RecipeType)YHBlocks.FERMENT_RT.get(), (Container)cont, maid.f_19853_);
        FluidStack fluidInTank = blockEntity.fluids.getFluidInTank(0);
        Fluid fluid = fluidInTank.getFluid();
        if (!fluidInTank.isEmpty() && beRecipe.isEmpty()) {
            boolean hasFluidContainer;
            if (fluid instanceof SakeFluid) {
                SakeFluid sakeFluid = (SakeFluid)fluid;
                ItemStack outputFluidContainers = sakeFluid.type.getContainer().m_7968_();
                hasFluidContainer = recManager.hasOutputAdditionItem(itemStack -> itemStack.m_150930_(outputFluidContainers.m_41720_()));
            } else {
                List outputFluidContainers = FLUID_CONTAINERS.getOrDefault(fluid, Collections.emptyList());
                hasFluidContainer = recManager.hasOutputAdditionItem(itemStack -> outputFluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_())));
            }
            if (hasFluidContainer) {
                return true;
            }
        }
        if (!blockEntity.items.m_7983_() && beRecipe.isEmpty()) {
            return true;
        }
        return fluidInTank.isEmpty() && blockEntity.items.m_7983_() && beRecipe.isEmpty() && blockEntity.inProgress() == 0.0f && !recManager.getRecipesIngredients().isEmpty();
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, FermentationTankBlockEntity blockEntity, MaidRecipesManager<FermentationRecipe<?>> recManager) {
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        IItemHandlerModifiable inputInv = recManager.getInputInv();
        IItemHandlerModifiable outputAdditionInv = recManager.getOutputAdditionInv();
        IItemHandlerModifiable outputInv = recManager.getOutputInv();
        boolean extracted = false;
        FermentationDummyContainer cont = new FermentationDummyContainer(blockEntity.items, blockEntity.fluids);
        Optional beRecipe = maid.f_19853_.m_7465_().m_44015_((RecipeType)YHBlocks.FERMENT_RT.get(), (Container)cont, maid.f_19853_);
        FluidStack fluidInTank = blockEntity.fluids.getFluidInTank(0);
        Fluid fluid = fluidInTank.getFluid();
        if (!fluidInTank.isEmpty() && beRecipe.isEmpty()) {
            ItemStack fluidContainer;
            if (fluid instanceof SakeFluid) {
                SakeFluid sakeFluid = (SakeFluid)fluid;
                outputFluidContainers = sakeFluid.type.getContainer().m_7968_();
                fluidContainer = recManager.findOutputAdditionItem(itemStack -> itemStack.m_150930_(outputFluidContainers.m_41720_()));
            } else {
                outputFluidContainers = FLUID_CONTAINERS.getOrDefault(fluid, Collections.emptyList());
                fluidContainer = recManager.findOutputAdditionItem(arg_0 -> TaskYhcFermentationTank.lambda$processCookMake$5((List)outputFluidContainers, arg_0));
            }
            while (!fluidInTank.isEmpty() && !fluidContainer.m_41619_()) {
                ItemStack interactItem = VItemStack.copyWithCount(fluidContainer, 1);
                ItemStack interactedItem = FakePlayerUtil.interactUseOnBlock(maid, blockEntity.m_58899_(), interactItem.m_41777_());
                if (!interactedItem.m_41619_()) {
                    if (!ItemStack.m_41656_((ItemStack)interactItem, (ItemStack)interactedItem)) {
                        leftItem = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)interactedItem, (boolean)false);
                        fluidContainer.m_41774_(1);
                        if (!leftItem.m_41619_()) {
                            maid.m_19983_(leftItem);
                        }
                    }
                } else if (fluid instanceof SakeFluid) {
                    SakeFluid sakeFluid = (SakeFluid)fluid;
                    leftItem = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)sakeFluid.type.asStack(1), (boolean)false);
                    fluidContainer.m_41774_(1);
                    if (!leftItem.m_41619_()) {
                        maid.m_19983_(leftItem);
                    }
                }
                blockEntity.notifyTile();
                extracted = true;
            }
            ItemStack leftItem = ItemHandlerHelper.insertItemStacked((IItemHandler)outputAdditionInv, (ItemStack)fluidContainer, (boolean)false);
            if (!leftItem.m_41619_()) {
                maid.m_19983_(leftItem);
            }
        }
        if (!blockEntity.items.m_7983_() && beRecipe.isEmpty()) {
            FermentationItemContainer items = blockEntity.items;
            for (int i = 0; i < items.m_6643_(); ++i) {
                ItemStack item = items.m_8020_(i);
                ItemStack leftItem = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)item.m_41777_(), (boolean)false);
                item.m_41774_(item.m_41613_() - leftItem.m_41613_());
                extracted = true;
            }
        }
        if (extracted) {
            IMaidsoulKitchenMaid.pickupAction(maid);
        }
        if (fluidInTank.isEmpty() && blockEntity.items.m_7983_() && beRecipe.isEmpty() && blockEntity.inProgress() == 0.0f && !recManager.getRecipesIngredients().isEmpty()) {
            Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = recManager.getRecipeIngredient();
            if (((List)recipeIngredient.getFirst()).isEmpty()) {
                return;
            }
            List fluidItems = (List)((List)recipeIngredient.getSecond()).get(0);
            int times = 0;
            while (times < (Integer)((List)recipeIngredient.getFirst()).get(0)) {
                for (ItemStack fluidItem : fluidItems) {
                    ItemStack interactedStack;
                    ItemStack interactItem = VItemStack.copyWithCount(fluidItem, 1);
                    if (!ItemStack.m_41656_((ItemStack)interactItem, (ItemStack)(interactedStack = FakePlayerUtil.interactUseOnBlock(maid, blockEntity.m_58899_(), interactItem.m_41777_())))) {
                        fluidItem.m_41774_(1);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)interactedStack, (boolean)false);
                    }
                    ++times;
                }
            }
            int i = 0;
            for (List itemStacks : (List)recipeIngredient.getSecond()) {
                if (i++ < 1) continue;
                Optional<ItemStack> first = itemStacks.stream().filter(stack -> !stack.m_41619_()).findFirst();
                first.ifPresent(stack -> {
                    ItemStack remain;
                    ItemStack copy = stack.m_41777_();
                    copy.m_41764_(1);
                    if (blockEntity.items.m_19183_(copy) && (remain = blockEntity.items.m_19173_(copy)).m_41619_()) {
                        stack.m_41774_(1);
                        blockEntity.notifyTile();
                    }
                });
            }
            serverLevel.m_46597_(blockEntity.m_58899_(), (BlockState)blockEntity.m_58900_().m_61124_((Property)FermentationTankBlock.OPEN, (Comparable)Boolean.valueOf(false)));
            blockEntity.notifyTile();
            IMaidsoulKitchenMaid.pickupAction(maid);
        }
    }

    public ResourceLocation getUid() {
        return TaskInfo.YHC_FERMENTATION_TANK.uid;
    }

    public ItemStack getIcon() {
        return YHBlocks.FERMENT.asStack();
    }

    @Override
    public List<FermentationRecipe<?>> getRecipes(Level level) {
        List<FermentationRecipe<?>> fermentationRecipes = ICookTask.super.getRecipes(level);
        if (FERMENTATION_RECIPE_INGREDIENTS.isEmpty()) {
            FLUID_CONTAINERS.clear();
            HashMap<Fluid, List> fluidItems1 = new HashMap<Fluid, List>();
            HashMap fluidContainers1 = new HashMap();
            for (Fluid fluid2 : ForgeRegistries.FLUIDS.getValues()) {
                ItemStack container;
                if (fluid2 instanceof EmptyFluid || (container = fluid2.m_6859_().m_7968_().getCraftingRemainingItem()).m_41619_()) continue;
                if (fluidContainers1.containsKey(fluid2)) {
                    List itemStacks2 = fluidContainers1.getOrDefault(fluid2, Collections.emptyList());
                    if (!itemStacks2.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks2.add(container);
                    continue;
                }
                fluidContainers1.put(fluid2, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack container;
                if (item instanceof SakeBottleItem) {
                    ItemStack container2;
                    SakeBottleItem sakeBottleItem = (SakeBottleItem)item;
                    SakeFluid sakeFluid = sakeBottleItem.getFluid();
                    IYHSake iyhSake = sakeFluid.type;
                    Fluid rawFluid = sakeFluid.m_5613_();
                    if (fluidItems1.containsKey(rawFluid)) {
                        List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                        if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(item))) {
                            ((List)fluidItems1.get(rawFluid)).add(Pair.of((Object)item.m_7968_(), (Object)iyhSake.amount()));
                        }
                    } else {
                        fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)item.m_7968_(), (Object)iyhSake.amount())}));
                    }
                    if ((container2 = iyhSake.getContainer().m_7968_()).m_41619_()) continue;
                    if (fluidContainers1.containsKey(rawFluid)) {
                        List itemStacks3 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                        if (!itemStacks3.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container2.m_41720_()))) continue;
                        itemStacks3.add(container2);
                        continue;
                    }
                    fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container2}));
                    continue;
                }
                ItemStack defaultInstance = item.m_7968_().m_41777_();
                IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)defaultInstance.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                if (iFluidHandlerItem == null || !(iFluidHandlerItem instanceof FluidBucketWrapper)) continue;
                FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
                FluidStack fluidStack = fluidBucketWrapper.getFluid();
                Fluid rawFluid = fluidStack.getRawFluid();
                if (fluidStack.isEmpty() || rawFluid instanceof EmptyFluid) continue;
                if (fluidItems1.containsKey(rawFluid)) {
                    List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                    if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(defaultInstance.m_41720_()))) {
                        ((List)fluidItems1.get(rawFluid)).add(Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount()));
                    }
                } else {
                    fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount())}));
                }
                if ((container = fluidBucketWrapper.getContainer().getCraftingRemainingItem()).m_41619_()) continue;
                if (fluidContainers1.containsKey(rawFluid)) {
                    List itemStacks4 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                    if (!itemStacks4.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks4.add(container);
                    continue;
                }
                fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            FLUID_CONTAINERS.putAll(fluidContainers1);
            for (FermentationRecipe fermentationRecipe : fermentationRecipes) {
                SimpleFermentationRecipe fermentationRecipe2 = (SimpleFermentationRecipe)fermentationRecipe;
                FluidStack fluidIn = fermentationRecipe2.inputFluid;
                if (fluidIn != null && !fluidIn.isEmpty()) {
                    ArrayList<ItemStack> fluidItems = new ArrayList<ItemStack>();
                    if (fluidItems1.keySet().stream().anyMatch(fluid -> fluid.m_6212_(fluidIn.getFluid()))) {
                        fluidItems1.forEach((fluid, itemStacks) -> {
                            if (fluid.m_6212_(fluidIn.getFluid())) {
                                for (Pair fluidStackPair : itemStacks) {
                                    ItemStack outputFluidItem = ((ItemStack)fluidStackPair.getFirst()).m_41777_();
                                    int amount = (Integer)fluidStackPair.getSecond();
                                    int amountTotal = fluidIn.getAmount();
                                    outputFluidItem.m_41764_(Math.max(1, amountTotal / amount));
                                    if (!fluidItems.stream().noneMatch(itemStack -> itemStack.m_150930_(outputFluidItem.m_41720_()) && itemStack.m_41613_() == outputFluidItem.m_41613_())) continue;
                                    fluidItems.add(outputFluidItem);
                                }
                            }
                        });
                    }
                    MaidFermentationRecipe maidKegFermentingRecipe = new MaidFermentationRecipe(fluidItems, fermentationRecipe2.ingredients);
                    FERMENTATION_RECIPE_INGREDIENTS.put(fermentationRecipe2, maidKegFermentingRecipe);
                    continue;
                }
                MaidFermentationRecipe maidKegFermentingRecipe = new MaidFermentationRecipe(Collections.emptyList(), fermentationRecipe2.ingredients);
                FERMENTATION_RECIPE_INGREDIENTS.put(fermentationRecipe2, maidKegFermentingRecipe);
            }
        }
        return fermentationRecipes;
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        SimpleFermentationRecipe fermentationRecipe = (SimpleFermentationRecipe)recipe;
        NonNullList ingredinetNonNullList = NonNullList.m_122779_();
        MaidFermentationRecipe maidKegRecipe = FERMENTATION_RECIPE_INGREDIENTS.get(fermentationRecipe);
        if (!maidKegRecipe.inFluids.isEmpty()) {
            ingredinetNonNullList.add((Object)Ingredient.m_43921_(maidKegRecipe.inFluids.stream()));
        } else {
            ingredinetNonNullList.add((Object)Ingredient.f_43901_);
        }
        ingredinetNonNullList.addAll(maidKegRecipe.inItems());
        return ingredinetNonNullList;
    }

    @Override
    public ItemStack getResultItem(Recipe<?> recipe, RegistryAccess pRegistryAccess) {
        SimpleFermentationRecipe fermentationRecipe = (SimpleFermentationRecipe)recipe;
        Fluid fluid = fermentationRecipe.outputFluid.getFluid();
        if (fluid instanceof SakeFluid) {
            SakeFluid sakeFluid = (SakeFluid)fluid;
            return sakeFluid.type.asStack(1);
        }
        return Items.f_41852_.m_7968_();
    }

    private static /* synthetic */ boolean lambda$processCookMake$5(List outputFluidContainers, ItemStack itemStack) {
        return outputFluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_()));
    }

    public record MaidFermentationRecipe(List<ItemStack> inFluids, List<Ingredient> inItems) {
    }
}

