/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.farmersrespite;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.entity.passive.IMaidsoulKitchenMaid;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cbaccessor.ICbeAccessor;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.farmersrespite.KettleRecipesManager;
import com.github.wallev.verhelper.server.item.VItemStack;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.farmersrespite.common.block.entity.KettleBlockEntity;
import umpaz.farmersrespite.common.crafting.KettlePouringRecipe;
import umpaz.farmersrespite.common.crafting.KettleRecipe;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;

public class TaskFrKettle
implements ICookTask<KettleBlockEntity, KettleRecipe> {
    protected static final Map<KettleRecipe, MaidKettleRecipe> KEY_RECIPE_INGREDIENTS = new HashMap<KettleRecipe, MaidKettleRecipe>();
    protected static final Map<Fluid, List<ItemStack>> FLUID_CONTAINERS = new HashMap<Fluid, List<ItemStack>>();

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof KettleBlockEntity;
    }

    @Override
    public RecipeType<KettleRecipe> getRecipeType() {
        return (RecipeType)FRRecipeTypes.BREWING.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, KettleBlockEntity kettleBlockEntity, MaidRecipesManager<KettleRecipe> recManager) {
        ItemStackHandler inventory = kettleBlockEntity.getInventory();
        if (!inventory.getStackInSlot(4).m_41619_()) {
            return true;
        }
        boolean innerCanCook = kettleBlockEntity.isHeated() && ((ICbeAccessor)kettleBlockEntity).tlmk$innerCanCook();
        Fluid outputFluid = kettleBlockEntity.getOutput().getFluid();
        List outputFluidContainers = FLUID_CONTAINERS.getOrDefault(outputFluid, Collections.emptyList());
        if (!innerCanCook && recManager.hasOutputAdditionItem(itemStack -> outputFluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_())))) {
            return true;
        }
        if (!innerCanCook && !recManager.getRecipesIngredients().isEmpty()) {
            return true;
        }
        boolean hasInput = false;
        if (!innerCanCook) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                hasInput = true;
                break;
            }
        }
        if (!innerCanCook && hasInput) {
            return true;
        }
        Fluid fluid = kettleBlockEntity.getFluidTank().getFluid().getFluid();
        List fluidContainers = FLUID_CONTAINERS.getOrDefault(fluid, Collections.emptyList());
        return !innerCanCook && recManager.hasOutputAdditionItem(itemStack -> fluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_())));
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, KettleBlockEntity kettleBlockEntity, MaidRecipesManager<KettleRecipe> recManager) {
        Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient;
        ItemStack container;
        kettleBlockEntity.m_6596_();
        ItemStackHandler inventory = kettleBlockEntity.getInventory();
        IItemHandlerModifiable inputInv = recManager.getInputInv();
        IItemHandlerModifiable outputInv = recManager.getOutputInv();
        IItemHandlerModifiable outputAdditionInv = recManager.getOutputAdditionInv();
        ItemStack output = inventory.getStackInSlot(4);
        if (!output.m_41619_()) {
            ItemStack outputCopy = output.m_41777_();
            ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)outputCopy, (boolean)false);
            output.m_41774_(outputCopy.m_41613_() - leftItemStack.m_41613_());
            kettleBlockEntity.m_6596_();
            ICookTask.awardExperience((BlockEntity)kettleBlockEntity, maid);
        }
        if (!(container = inventory.getStackInSlot(3)).m_41619_()) {
            ItemStack containerCopy = container.m_41777_();
            ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputAdditionInv, (ItemStack)containerCopy, (boolean)false);
            container.m_41774_(containerCopy.m_41613_() - leftItemStack.m_41613_());
            kettleBlockEntity.m_6596_();
        }
        boolean innerCanCook = kettleBlockEntity.isHeated() && ((ICbeAccessor)kettleBlockEntity).tlmk$innerCanCook();
        Fluid outputFluid = kettleBlockEntity.getOutput().getFluid();
        List outputFluidContainers = FLUID_CONTAINERS.getOrDefault(outputFluid, Collections.emptyList());
        ItemStack outputAdditionItem = recManager.findOutputAdditionItem(itemStack -> outputFluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_())));
        if (!innerCanCook && !outputAdditionItem.m_41619_()) {
            ItemStack output2;
            inventory.insertItem(3, outputAdditionItem, false);
            ItemStack container2 = inventory.getStackInSlot(2);
            if (!container2.m_41619_()) {
                ItemStack containerCopy = container2.m_41777_();
                ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputAdditionInv, (ItemStack)containerCopy, (boolean)false);
                container2.m_41774_(containerCopy.m_41613_() - leftItemStack.m_41613_());
            }
            if (!(output2 = inventory.getStackInSlot(4)).m_41619_()) {
                ItemStack outputCopy = output2.m_41777_();
                ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)outputCopy, (boolean)false);
                output2.m_41774_(outputCopy.m_41613_() - leftItemStack.m_41613_());
            }
            kettleBlockEntity.m_6596_();
        }
        boolean hasInput = false;
        if (!innerCanCook) {
            for (int i = 0; i < 2; ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack copy = stack.m_41777_();
                ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)copy, (boolean)false);
                stack.m_41774_(copy.m_41613_() - leftItemStack.m_41613_());
                if (stack.m_41619_()) continue;
                hasInput = true;
            }
            kettleBlockEntity.m_6596_();
        }
        IMaidsoulKitchenMaid.pickupAction(maid);
        if (!innerCanCook && !hasInput && kettleBlockEntity.getFluidTank().isEmpty() && !recManager.getRecipesIngredients().isEmpty() && this.hasEnoughIngredient((List)(recipeIngredient = recManager.getRecipeIngredient()).getFirst(), (List)recipeIngredient.getSecond())) {
            int amount = (Integer)((List)recipeIngredient.getFirst()).get(0);
            for (ItemStack itemStack2 : (List)((List)recipeIngredient.getSecond()).get(0)) {
                ItemStack leftInsertedStack;
                ItemStack fluidExtract;
                int i;
                if (itemStack2.m_41619_()) continue;
                int count = itemStack2.m_41613_();
                if (count >= amount) {
                    for (i = 0; i < amount; ++i) {
                        fluidExtract = kettleBlockEntity.fluidExtract(kettleBlockEntity, VItemStack.copyWithCount(itemStack2, 1), ItemStack.f_41583_);
                        leftInsertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)fluidExtract, (boolean)false);
                        itemStack2.m_41774_(1 - leftInsertedStack.m_41613_());
                    }
                    ItemStack leftInsertedStack2 = inventory.insertItem(3, VItemStack.copyWithCount(itemStack2, amount), false);
                    itemStack2.m_41774_(amount - leftInsertedStack2.m_41613_());
                    break;
                }
                for (i = 0; i < count; ++i) {
                    fluidExtract = kettleBlockEntity.fluidExtract(kettleBlockEntity, VItemStack.copyWithCount(itemStack2, 1), ItemStack.f_41583_);
                    leftInsertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)fluidExtract, (boolean)false);
                    itemStack2.m_41774_(1 - leftInsertedStack.m_41613_());
                }
                if ((amount -= count) > 0) continue;
                break;
            }
            this.insertInputsStack(inventory, inputInv, kettleBlockEntity, recipeIngredient);
            kettleBlockEntity.m_6596_();
            IMaidsoulKitchenMaid.pickupAction(maid);
        }
    }

    private boolean hasEnoughIngredient(List<Integer> amounts, List<List<ItemStack>> ingredients) {
        boolean canInsert = true;
        int i = 0;
        for (List<ItemStack> ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            int actualCount = amounts.get(i++);
            for (ItemStack itemStack : ingredient) {
                if ((actualCount -= itemStack.m_41613_()) <= 0) break;
            }
            if (actualCount <= 0) continue;
            canInsert = false;
            break;
        }
        return canInsert;
    }

    private void insertInputsStack(ItemStackHandler beInv, IItemHandlerModifiable ingreInputsInv, KettleBlockEntity be, Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
        List amounts = (List)ingredientPair.getFirst();
        List ingredients = (List)ingredientPair.getSecond();
        int i = 0;
        int j = 0;
        while (i < ingredients.size() - 1) {
            this.insertAndShrink(beInv, (Integer)amounts.get(j + 1), ingredients, j + 1, i);
            ++i;
            ++j;
        }
        be.m_6596_();
    }

    private void insertAndShrink(ItemStackHandler beInv, Integer amount, List<List<ItemStack>> ingredient, int ingredientIndex, int slotIndex) {
        for (ItemStack itemStack : ingredient.get(ingredientIndex)) {
            ItemStack leftInsertedStack;
            if (itemStack.m_41619_()) continue;
            int count = itemStack.m_41613_();
            if (count >= amount) {
                leftInsertedStack = beInv.insertItem(slotIndex, VItemStack.copyWithCount(itemStack, amount), false);
                itemStack.m_41774_(amount - leftInsertedStack.m_41613_());
                break;
            }
            leftInsertedStack = beInv.insertItem(slotIndex, VItemStack.copyWithCount(itemStack, count), false);
            itemStack.m_41774_(count - leftInsertedStack.m_41613_());
            if ((amount = Integer.valueOf(amount - count)) > 0) continue;
            break;
        }
    }

    @Override
    public List<KettleRecipe> getRecipes(Level level) {
        if (KEY_RECIPE_INGREDIENTS.isEmpty()) {
            FLUID_CONTAINERS.clear();
            HashMap<Fluid, List> fluidItems1 = new HashMap<Fluid, List>();
            HashMap fluidContainers1 = new HashMap();
            for (Fluid fluid2 : ForgeRegistries.FLUIDS.getValues()) {
                ItemStack container;
                if (fluid2 instanceof EmptyFluid || (container = fluid2.m_6859_().m_7968_().getCraftingRemainingItem()).m_41619_()) continue;
                if (fluidContainers1.containsKey(fluid2)) {
                    List itemStacks2 = fluidContainers1.getOrDefault(fluid2, Collections.emptyList());
                    if (!itemStacks2.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks2.add(container);
                    continue;
                }
                fluidContainers1.put(fluid2, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack container;
                ItemStack defaultInstance = item.m_7968_().m_41777_();
                IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)defaultInstance.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                if (iFluidHandlerItem == null || !(iFluidHandlerItem instanceof FluidBucketWrapper)) continue;
                FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
                FluidStack fluidStack = fluidBucketWrapper.getFluid();
                Fluid rawFluid = fluidStack.getRawFluid();
                if (fluidStack.isEmpty() || rawFluid instanceof EmptyFluid) continue;
                if (fluidItems1.containsKey(rawFluid)) {
                    List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                    if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(defaultInstance.m_41720_()))) {
                        ((List)fluidItems1.get(rawFluid)).add(Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount()));
                    }
                } else {
                    fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount())}));
                }
                if ((container = fluidBucketWrapper.getContainer().getCraftingRemainingItem()).m_41619_()) continue;
                if (fluidContainers1.containsKey(rawFluid)) {
                    List itemStacks3 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                    if (!itemStacks3.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks3.add(container);
                    continue;
                }
                fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            List kettlePouringRecipes = level.m_7465_().m_44013_((RecipeType)FRRecipeTypes.KETTLE_POURING.get());
            List kettleRecipes = level.m_7465_().m_44013_((RecipeType)FRRecipeTypes.BREWING.get());
            for (KettlePouringRecipe kettlePouringRecipe : kettlePouringRecipes) {
                ItemStack container;
                Fluid rawFluid = kettlePouringRecipe.getFluid();
                if (rawFluid instanceof EmptyFluid) continue;
                ItemStack itemStack = kettlePouringRecipe.getOutput().m_41777_();
                if (!itemStack.m_41619_()) {
                    if (fluidItems1.containsKey(rawFluid)) {
                        List itemStacks4 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                        if (itemStacks4.stream().noneMatch(itemStack1 -> ((ItemStack)itemStack1.getFirst()).m_150930_(itemStack.m_41720_()))) {
                            itemStacks4.add(Pair.of((Object)itemStack, (Object)kettlePouringRecipe.getAmount()));
                        }
                    } else {
                        fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)itemStack, (Object)kettlePouringRecipe.getAmount())}));
                    }
                }
                if ((container = VItemStack.copyWithCount(kettlePouringRecipe.getContainer(), 1)).m_41619_()) continue;
                if (fluidContainers1.containsKey(rawFluid)) {
                    List itemStacks5 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                    if (!itemStacks5.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks5.add(container);
                    continue;
                }
                fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            FLUID_CONTAINERS.putAll(fluidContainers1);
            for (KettleRecipe kettleRecipe : kettleRecipes) {
                List<KettlePouringRecipe> matchKegPouringRecipes;
                FluidStack fluidOut;
                List<ItemStack> inFluids = Collections.emptyList();
                ItemStack output = ItemStack.f_41583_;
                FluidStack fluidIn = kettleRecipe.getFluidIn();
                if (fluidIn != null && !fluidIn.isEmpty() && fluidItems1.keySet().stream().anyMatch(fluid -> fluid.m_6212_(fluidIn.getFluid()))) {
                    ArrayList<ItemStack> fluidItems = new ArrayList<ItemStack>();
                    fluidItems1.forEach((fluid, itemStacks) -> {
                        if (fluid.m_6212_(fluidIn.getFluid())) {
                            for (Pair fluidStackPair : itemStacks) {
                                ItemStack outputFluidItem = ((ItemStack)fluidStackPair.getFirst()).m_41777_();
                                int amount = (Integer)fluidStackPair.getSecond();
                                int amountTotal = fluidIn.getAmount();
                                outputFluidItem.m_41764_(Math.max(1, amountTotal / amount));
                                if (!fluidItems.stream().noneMatch(itemStack -> itemStack.m_150930_(outputFluidItem.m_41720_()) && itemStack.m_41613_() == outputFluidItem.m_41613_())) continue;
                                fluidItems.add(outputFluidItem);
                            }
                        }
                    });
                    inFluids = fluidItems;
                }
                if ((fluidOut = kettleRecipe.getFluidOut()) != null && !fluidOut.isEmpty() && !(matchKegPouringRecipes = kettlePouringRecipes.stream().filter(pouringRecipe -> pouringRecipe.getFluid().m_6212_(fluidOut.getFluid())).toList()).isEmpty()) {
                    output = matchKegPouringRecipes.get(0).getOutput();
                }
                MaidKettleRecipe maidKettleRecipe = new MaidKettleRecipe(inFluids, (List<Ingredient>)kettleRecipe.m_7527_(), output);
                KEY_RECIPE_INGREDIENTS.put(kettleRecipe, maidKettleRecipe);
            }
        }
        return KEY_RECIPE_INGREDIENTS.keySet().stream().toList();
    }

    @Override
    public MaidRecipesManager<KettleRecipe> getRecipesManager(EntityMaid maid) {
        return new KettleRecipesManager(maid, this);
    }

    public ResourceLocation getUid() {
        return TaskInfo.FR_KETTLE.uid;
    }

    public ItemStack getIcon() {
        return ((Item)FRItems.KETTLE.get()).m_7968_();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return DataRegister.FR_KETTLE;
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        NonNullList ingredinetNonNullList = NonNullList.m_122779_();
        MaidKettleRecipe maidKettleRecipe = KEY_RECIPE_INGREDIENTS.get((KettleRecipe)recipe);
        if (!maidKettleRecipe.inFluids.isEmpty()) {
            ingredinetNonNullList.add((Object)Ingredient.m_43921_(maidKettleRecipe.inFluids.stream()));
        }
        ingredinetNonNullList.addAll(maidKettleRecipe.inItems());
        return ingredinetNonNullList;
    }

    @Override
    public ItemStack getResultItem(Recipe<?> recipe, RegistryAccess pRegistryAccess) {
        return KEY_RECIPE_INGREDIENTS.get((KettleRecipe)recipe).output();
    }

    protected void pickupAction(EntityMaid maid) {
        maid.m_6674_(InteractionHand.MAIN_HAND);
        maid.m_5496_(SoundEvents.f_12019_, 1.0f, maid.m_217043_().m_188501_() * 0.1f + 1.0f);
    }

    public record MaidKettleRecipe(List<ItemStack> inFluids, List<Ingredient> inItems, ItemStack output) {
    }
}

