/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.cuisine;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.entity.passive.IMaidsoulKitchenMaid;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.cuisine.TaskCdCuisineSkillet;
import com.github.wallev.verhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class MaidCuisineMakeTask
extends Behavior<EntityMaid>
implements VBehaviorControl {
    private final TaskCdCuisineSkillet task;
    private final MaidRecipesManager<BaseCuisineRecipe<?>> maidRecipesManager;
    private int tickAll = 0;
    private int tickMax = 0;
    private int tickSpace = Integer.MAX_VALUE;
    private List<Pair<Integer, ItemStack>> processTickStacks = new ArrayList<Pair<Integer, ItemStack>>();
    private ItemStack plateItem = ItemStack.f_41583_;
    private boolean end = false;

    public MaidCuisineMakeTask(TaskCdCuisineSkillet task, MaidRecipesManager<BaseCuisineRecipe<?>> maidRecipesManager) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.task = task;
        this.maidRecipesManager = maidRecipesManager;
    }

    private static int getReduction(ItemStack stack) {
        return stack.getEnchantmentLevel(Enchantments.f_44985_) > 0 ? 20 : 0;
    }

    public static void playSound(EntityMaid maid, Level level, SoundEvent event) {
        Vec3 pos = maid.m_20182_();
        double x = pos.m_7096_() + 0.5;
        double y = pos.m_7098_();
        double z = pos.m_7094_() + 0.5;
        level.m_7785_(x, y, z, event, SoundSource.BLOCKS, 0.4f, level.f_46441_.m_188501_() * 0.2f + 0.9f, false);
    }

    private static void processV1(ServerLevel worldIn, EntityMaid maid, CuisineSkilletBlockEntity cuisineSkilletBlockEntity) {
        if (!cuisineSkilletBlockEntity.cookingData.contents.isEmpty()) {
            if (!worldIn.m_5776_()) {
                cuisineSkilletBlockEntity.stir(worldIn.m_46467_(), MaidCuisineMakeTask.getReduction(maid.m_21205_()));
            } else {
                MaidCuisineMakeTask.playSound(maid, (Level)worldIn, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get());
            }
            maid.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        Brain brain = maid.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            if (maid.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        return maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get()) && !this.end;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6735_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof CuisineSkilletBlockEntity) {
                int plateSlot;
                CuisineSkilletBlockEntity cuisineSkilletBlockEntity = (CuisineSkilletBlockEntity)blockEntity;
                CombinedInvWrapper maidAvailableInv = maid.getAvailableInv(true);
                ItemStack mainHandItem = maid.m_21205_();
                if (!mainHandItem.m_150930_((Item)CDItems.SPATULA.get())) {
                    int stackSlot = ItemsUtil.findStackSlot((IItemHandler)maidAvailableInv, itemStack -> itemStack.m_150930_((Item)CDItems.SPATULA.get()));
                    if (stackSlot == -1) {
                        return;
                    }
                    ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)mainHandItem, (boolean)false);
                    if (!leftStack.m_41619_()) {
                        return;
                    }
                    maid.m_21008_(InteractionHand.MAIN_HAND, maidAvailableInv.getStackInSlot(stackSlot));
                }
                if ((plateSlot = ItemsUtil.findStackSlot((IItemHandler)maidAvailableInv, itemStack -> itemStack.m_150930_((Item)CDItems.PLATE.get()))) <= -1) {
                    return;
                }
                this.plateItem = maidAvailableInv.getStackInSlot(plateSlot);
                Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = this.maidRecipesManager.getRecipeIngredient();
                block0: for (List itemStacks : (List)recipeIngredient.getSecond()) {
                    for (ItemStack itemStack2 : itemStacks) {
                        if (itemStack2.m_41619_()) continue;
                        IngredientConfig.IngredientEntry entry = IngredientConfig.get().getEntry(itemStack2);
                        if (entry == null) continue block0;
                        this.tickMax = Math.max(this.tickMax, entry.min_time);
                        this.tickSpace = Math.min(this.tickSpace, entry.stir_time);
                        this.processTickStacks.add((Pair<Integer, ItemStack>)Pair.of((Object)entry.min_time, (Object)itemStack2));
                        continue block0;
                    }
                }
                this.processTickStacks.sort((a, b) -> (Integer)a.getFirst() == 0 ? -1 : Integer.compare((Integer)b.getFirst(), (Integer)a.getFirst()));
                WeakReference<FakePlayer> fakePlayer$tlma = ((IMaidsoulKitchenMaid)maid).tlmk$getFakePlayer();
                FakePlayer fakePlayer = (FakePlayer)fakePlayer$tlma.get();
                if (fakePlayer != null) {
                    Integer time = (Integer)this.processTickStacks.get(0).getFirst();
                    List<Pair> list = this.processTickStacks.stream().filter(pair -> pair.getFirst() == time || (Integer)pair.getFirst() == this.tickMax).toList();
                    this.processTickStacks.removeAll(list);
                    for (Pair integerItemStackPair : list) {
                        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ((ItemStack)integerItemStackPair.getSecond()).m_41620_(1));
                        this.interactUseOnBlock(maid, blockEntity.m_58899_(), InteractionHand.MAIN_HAND, null);
                        maid.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                this.maidRecipesManager.getCookInv().syncInv();
            }
        });
    }

    protected void tick(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        ++this.tickAll;
        super.m_6725_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof CuisineSkilletBlockEntity) {
                WeakReference<FakePlayer> fakePlayer$tlma;
                FakePlayer fakePlayer;
                Pair<Integer, ItemStack> pair;
                CuisineSkilletBlockEntity cuisineSkilletBlockEntity = (CuisineSkilletBlockEntity)blockEntity;
                if ((this.tickAll + 10) % this.tickSpace == 0) {
                    MaidCuisineMakeTask.processV1(worldIn, maid, cuisineSkilletBlockEntity);
                }
                if (!this.processTickStacks.isEmpty() && this.tickAll + 10 == this.tickMax - (Integer)(pair = this.processTickStacks.get(0)).getFirst() && (fakePlayer = (FakePlayer)(fakePlayer$tlma = ((IMaidsoulKitchenMaid)maid).tlmk$getFakePlayer()).get()) != null) {
                    Integer time = (Integer)pair.getFirst();
                    List<Pair> list = this.processTickStacks.stream().filter(pair1 -> pair1.getFirst() == time || (Integer)pair1.getFirst() == this.tickMax).toList();
                    this.processTickStacks.removeAll(list);
                    for (Pair integerItemStackPair : list) {
                        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ((ItemStack)integerItemStackPair.getSecond()).m_41620_(1));
                        this.interactUseOnBlock(maid, blockEntity.m_58899_(), InteractionHand.MAIN_HAND, null);
                        maid.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                if (this.tickAll - 10 >= this.tickMax) {
                    CombinedInvWrapper maidAvailableInv = maid.getAvailableInv(true);
                    CookingData data = cuisineSkilletBlockEntity.cookingData;
                    data.stir(worldIn.m_46467_(), 0);
                    CookedFoodData food = new CookedFoodData(data);
                    ItemStack foodStack = BaseCuisineRecipe.findBestMatch((Level)worldIn, (CookedFoodData)food);
                    this.plateItem.m_41774_(1);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)foodStack, (boolean)false);
                    cuisineSkilletBlockEntity.cookingData = new CookingData();
                    cuisineSkilletBlockEntity.sync();
                    maid.m_6674_(InteractionHand.MAIN_HAND);
                    this.end = true;
                }
            }
        });
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6732_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21936_((MemoryModuleType)MkEntities.WORK_POS.get());
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.tickAll = 0;
        this.tickMax = 0;
        this.tickSpace = Integer.MAX_VALUE;
        this.processTickStacks.clear();
        this.plateItem = ItemStack.f_41583_;
        this.end = false;
    }

    private InteractionResult interactUseOnBlock(EntityMaid maid, BlockPos targetPos, InteractionHand hand, @Nullable Direction facing) {
        FakePlayer fakePlayer = (FakePlayer)((IMaidsoulKitchenMaid)maid).tlmk$getFakePlayer().get();
        Direction placementOn = facing == null ? fakePlayer.m_6374_() : facing;
        BlockHitResult blockraytraceresult = new BlockHitResult(fakePlayer.m_20154_(), placementOn, targetPos, true);
        ItemStack itemInHand = fakePlayer.m_21120_(hand);
        return fakePlayer.f_8941_.m_7179_((ServerPlayer)fakePlayer, maid.f_19853_, itemInHand, hand, blockraytraceresult);
    }
}

