/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.brewinandchewin;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.entity.passive.IMaidsoulKitchenMaid;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.brewinandchewin.KegFermentingRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.brewinandchewin.MaidFermentingMoveTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.MaidCookMakeTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.cbaccessor.ICbeAccessor;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.github.wallev.verhelper.server.ai.VBehaviorControl;
import com.github.wallev.verhelper.server.item.VItemStack;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCBlocks;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;

public class TaskBncKeg
implements ICookTask<KegBlockEntity, KegFermentingRecipe> {
    protected static final Map<KegFermentingRecipe, MaidKegRecipe> KEG_RECIPE_INGREDIENTS = new HashMap<KegFermentingRecipe, MaidKegRecipe>();
    protected static final Map<Fluid, List<ItemStack>> FLUID_CONTAINERS = new HashMap<Fluid, List<ItemStack>>();

    private static BlockPos getSearchPos(EntityMaid maid) {
        return maid.m_21536_() ? maid.m_21534_() : maid.m_20183_().m_7495_();
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof KegBlockEntity;
    }

    @Override
    public RecipeType<KegFermentingRecipe> getRecipeType() {
        return (RecipeType)BnCRecipeTypes.FERMENTING.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, KegBlockEntity kegBlockEntity, MaidRecipesManager<KegFermentingRecipe> recManager) {
        ItemStackHandler inventory = kegBlockEntity.getInventory();
        KegFermentingRecipesManager kegFermentingRecipesManager = (KegFermentingRecipesManager)recManager;
        if (!inventory.getStackInSlot(5).m_41619_()) {
            return true;
        }
        boolean innerCanCook = ((ICbeAccessor)kegBlockEntity).tlmk$innerCanCook();
        Fluid outputFluid = kegBlockEntity.getOutput().getFluid();
        List outputFluidContainers = FLUID_CONTAINERS.getOrDefault(outputFluid, Collections.emptyList());
        if (!innerCanCook && recManager.hasOutputAdditionItem(itemStack -> outputFluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_())))) {
            return true;
        }
        if (!innerCanCook && kegFermentingRecipesManager.hasRecipeIngredientsWithTemp(kegBlockEntity.getTemperature())) {
            return true;
        }
        boolean hasInput = false;
        if (!innerCanCook) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                hasInput = true;
                break;
            }
        }
        if (!innerCanCook && hasInput) {
            return true;
        }
        Fluid fluid = kegBlockEntity.getFluidTank().getFluid().getFluid();
        List fluidContainers = FLUID_CONTAINERS.getOrDefault(fluid, Collections.emptyList());
        return !innerCanCook && recManager.hasOutputAdditionItem(itemStack -> fluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_())));
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, KegBlockEntity kegBlockEntity, MaidRecipesManager<KegFermentingRecipe> recManager) {
        Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient;
        ItemStack container;
        KegFermentingRecipesManager kegFermentingRecipesManager = (KegFermentingRecipesManager)recManager;
        ItemStackHandler inventory = kegBlockEntity.getInventory();
        IItemHandlerModifiable inputInv = recManager.getInputInv();
        IItemHandlerModifiable outputInv = recManager.getOutputInv();
        IItemHandlerModifiable outputAdditionInv = recManager.getOutputAdditionInv();
        ItemStack output = inventory.getStackInSlot(5);
        if (!output.m_41619_()) {
            ItemStack outputCopy = output.m_41777_();
            ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)outputCopy, (boolean)false);
            output.m_41774_(outputCopy.m_41613_() - leftItemStack.m_41613_());
            kegBlockEntity.m_6596_();
            ICookTask.awardExperience((BlockEntity)kegBlockEntity, maid);
        }
        if (!(container = inventory.getStackInSlot(4)).m_41619_()) {
            ItemStack containerCopy = container.m_41777_();
            ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputAdditionInv, (ItemStack)containerCopy, (boolean)false);
            container.m_41774_(containerCopy.m_41613_() - leftItemStack.m_41613_());
            kegBlockEntity.m_6596_();
        }
        boolean innerCanCook = ((ICbeAccessor)kegBlockEntity).tlmk$innerCanCook();
        Fluid outputFluid = kegBlockEntity.getOutput().getFluid();
        List outputFluidContainers = FLUID_CONTAINERS.getOrDefault(outputFluid, Collections.emptyList());
        ItemStack outputAdditionItem = recManager.findOutputAdditionItem(itemStack -> outputFluidContainers.stream().anyMatch(stack -> stack.m_150930_(itemStack.m_41720_())));
        if (!innerCanCook && !outputAdditionItem.m_41619_()) {
            ItemStack copy = outputAdditionItem.m_41777_();
            outputAdditionItem.m_41764_(0);
            List extracted = kegBlockEntity.extractInWorld(kegBlockEntity, copy, copy.m_41613_(), false);
            extracted.add(copy);
            for (ItemStack stack : extracted) {
                ItemStack leftInsertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)stack, (boolean)false);
                if (leftInsertedStack.m_41619_()) continue;
                maid.m_19983_(leftInsertedStack);
            }
        }
        boolean hasInput = false;
        if (!innerCanCook) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack copy = stack.m_41777_();
                ItemStack leftItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)copy, (boolean)false);
                stack.m_41774_(copy.m_41613_() - leftItemStack.m_41613_());
                if (stack.m_41619_()) continue;
                hasInput = true;
            }
            kegBlockEntity.m_6596_();
        }
        IMaidsoulKitchenMaid.pickupAction(maid);
        if (!innerCanCook && !hasInput && kegBlockEntity.getFluidTank().isEmpty() && kegFermentingRecipesManager.hasRecipeIngredientsWithTemp(kegBlockEntity.getTemperature()) && this.hasEnoughIngredient((List)(recipeIngredient = kegFermentingRecipesManager.getRecipeIngredient(kegBlockEntity.getTemperature())).getFirst(), (List)recipeIngredient.getSecond())) {
            int amount = (Integer)((List)recipeIngredient.getFirst()).get(0);
            for (ItemStack itemStack2 : (List)((List)recipeIngredient.getSecond()).get(0)) {
                ItemStack leftInsertedStack;
                List extracted;
                if (itemStack2.m_41619_()) continue;
                int count = itemStack2.m_41613_();
                if (count >= amount) {
                    extracted = kegBlockEntity.extractInWorld(kegBlockEntity, VItemStack.copyWithCount(itemStack2, amount), amount, false);
                    if (extracted.isEmpty()) {
                        return;
                    }
                    itemStack2.m_41774_(amount);
                    for (ItemStack stack : extracted) {
                        leftInsertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)stack, (boolean)false);
                        if (leftInsertedStack.m_41619_()) continue;
                        maid.m_19983_(leftInsertedStack);
                    }
                    break;
                }
                extracted = kegBlockEntity.extractInWorld(kegBlockEntity, VItemStack.copyWithCount(itemStack2, count), count, false);
                itemStack2.m_41774_(count);
                for (ItemStack stack : extracted) {
                    leftInsertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)stack, (boolean)false);
                    if (leftInsertedStack.m_41619_()) continue;
                    maid.m_19983_(leftInsertedStack);
                }
                if ((amount -= count) > 0) continue;
                break;
            }
            this.insertInputsStack(inventory, inputInv, kegBlockEntity, recipeIngredient);
            kegBlockEntity.m_6596_();
            IMaidsoulKitchenMaid.pickupAction(maid);
        }
    }

    private boolean hasEnoughIngredient(List<Integer> amounts, List<List<ItemStack>> ingredients) {
        boolean canInsert = true;
        int i = 0;
        for (List<ItemStack> ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            int actualCount = amounts.get(i++);
            for (ItemStack itemStack : ingredient) {
                if (!itemStack.m_41619_() && (actualCount -= itemStack.m_41613_()) <= 0) break;
            }
            if (actualCount <= 0) continue;
            canInsert = false;
            break;
        }
        return canInsert;
    }

    private void insertInputsStack(ItemStackHandler beInv, IItemHandlerModifiable ingreInputsInv, KegBlockEntity be, Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
        List amounts = (List)ingredientPair.getFirst();
        List ingredients = (List)ingredientPair.getSecond();
        int i = 0;
        int j = 0;
        while (i < ingredients.size() - 1) {
            this.insertAndShrink(beInv, (Integer)amounts.get(j + 1), ingredients, j + 1, i);
            ++i;
            ++j;
        }
        be.m_6596_();
    }

    private void insertAndShrink(ItemStackHandler beInv, Integer amount, List<List<ItemStack>> ingredient, int ingredientIndex, int slotIndex) {
        for (ItemStack itemStack : ingredient.get(ingredientIndex)) {
            ItemStack leftInsertedStack;
            if (itemStack.m_41619_()) continue;
            int count = itemStack.m_41613_();
            if (count >= amount) {
                leftInsertedStack = beInv.insertItem(slotIndex, VItemStack.copyWithCount(itemStack, amount), false);
                itemStack.m_41774_(amount - leftInsertedStack.m_41613_());
                break;
            }
            leftInsertedStack = beInv.insertItem(slotIndex, VItemStack.copyWithCount(itemStack, count), false);
            itemStack.m_41774_(count - leftInsertedStack.m_41613_());
            if ((amount = Integer.valueOf(amount - count)) > 0) continue;
            break;
        }
    }

    @Override
    public List<Pair<Integer, VBehaviorControl>> vCreateBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Collections.emptyList();
        }
        MaidRecipesManager<KegFermentingRecipe> cookingPotRecipeMaidRecipesManager = this.getRecipesManager(maid);
        MaidFermentingMoveTask maidCookMoveTask = new MaidFermentingMoveTask(this, (KegFermentingRecipesManager)cookingPotRecipeMaidRecipesManager);
        MaidCookMakeTask<KegBlockEntity, KegFermentingRecipe> maidCookMakeTask = new MaidCookMakeTask<KegBlockEntity, KegFermentingRecipe>(this, cookingPotRecipeMaidRecipesManager);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)maidCookMoveTask), Pair.of((Object)6, maidCookMakeTask)});
    }

    @Override
    public List<KegFermentingRecipe> getRecipes(Level level) {
        if (KEG_RECIPE_INGREDIENTS.isEmpty()) {
            FLUID_CONTAINERS.clear();
            HashMap<Fluid, List> fluidItems1 = new HashMap<Fluid, List>();
            HashMap fluidContainers1 = new HashMap();
            for (Fluid fluid2 : ForgeRegistries.FLUIDS.getValues()) {
                ItemStack container;
                if (fluid2 instanceof EmptyFluid || (container = fluid2.m_6859_().m_7968_().getCraftingRemainingItem()).m_41619_()) continue;
                if (fluidContainers1.containsKey(fluid2)) {
                    List itemStacks2 = fluidContainers1.getOrDefault(fluid2, Collections.emptyList());
                    if (!itemStacks2.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks2.add(container);
                    continue;
                }
                fluidContainers1.put(fluid2, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack container;
                ItemStack defaultInstance = item.m_7968_().m_41777_();
                IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)defaultInstance.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                if (iFluidHandlerItem == null || !(iFluidHandlerItem instanceof FluidBucketWrapper)) continue;
                FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
                FluidStack fluidStack = fluidBucketWrapper.getFluid();
                Fluid rawFluid = fluidStack.getRawFluid();
                if (fluidStack.isEmpty() || rawFluid instanceof EmptyFluid) continue;
                if (fluidItems1.containsKey(rawFluid)) {
                    List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                    if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(defaultInstance.m_41720_()))) {
                        ((List)fluidItems1.get(rawFluid)).add(Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount()));
                    }
                } else {
                    fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount())}));
                }
                if ((container = fluidBucketWrapper.getContainer().getCraftingRemainingItem()).m_41619_()) continue;
                if (fluidContainers1.containsKey(rawFluid)) {
                    List itemStacks3 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                    if (!itemStacks3.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks3.add(container);
                    continue;
                }
                fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            List kegPouringRecipes = level.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get());
            List KegFermentingRecipes = level.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.FERMENTING.get());
            for (KegPouringRecipe kegPouringRecipe : kegPouringRecipes) {
                ItemStack container;
                Fluid rawFluid = kegPouringRecipe.getRawFluid();
                if (rawFluid instanceof EmptyFluid) continue;
                ItemStack itemStack = kegPouringRecipe.getOutput().m_41777_();
                if (!itemStack.m_41619_()) {
                    if (fluidItems1.containsKey(rawFluid)) {
                        List itemStacks4 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                        if (itemStacks4.stream().noneMatch(itemStack1 -> ((ItemStack)itemStack1.getFirst()).m_150930_(itemStack.m_41720_()))) {
                            itemStacks4.add(Pair.of((Object)itemStack, (Object)kegPouringRecipe.getAmount()));
                        }
                    } else {
                        fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)itemStack, (Object)kegPouringRecipe.getAmount())}));
                    }
                }
                if ((container = VItemStack.copyWithCount(kegPouringRecipe.getContainer(), 1)).m_41619_()) continue;
                if (fluidContainers1.containsKey(rawFluid)) {
                    List itemStacks5 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                    if (!itemStacks5.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                    itemStacks5.add(container);
                    continue;
                }
                fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
            }
            FLUID_CONTAINERS.putAll(fluidContainers1);
            for (KegFermentingRecipe kegFermentingRecipe : KegFermentingRecipes) {
                FluidStack fluidIn = kegFermentingRecipe.getFluidIngredient();
                if (fluidIn != null && !fluidIn.isEmpty()) {
                    ArrayList<ItemStack> fluidItems = new ArrayList<ItemStack>();
                    if (fluidItems1.keySet().stream().anyMatch(fluid -> fluid.m_6212_(fluidIn.getFluid()))) {
                        fluidItems1.forEach((fluid, itemStacks) -> {
                            if (fluid.m_6212_(fluidIn.getFluid())) {
                                for (Pair fluidStackPair : itemStacks) {
                                    ItemStack outputFluidItem = ((ItemStack)fluidStackPair.getFirst()).m_41777_();
                                    int amount = (Integer)fluidStackPair.getSecond();
                                    int amountTotal = fluidIn.getAmount();
                                    outputFluidItem.m_41764_(Math.max(1, amountTotal / amount));
                                    if (!fluidItems.stream().noneMatch(itemStack -> itemStack.m_150930_(outputFluidItem.m_41720_()) && itemStack.m_41613_() == outputFluidItem.m_41613_())) continue;
                                    fluidItems.add(outputFluidItem);
                                }
                            }
                        });
                    } else {
                        ItemStack otherFluidItem = BnCFluidItemDisplays.getFluidItemDisplay((RegistryAccess)level.m_9598_(), (FluidStack)fluidIn);
                        fluidItems.add(otherFluidItem.m_41777_());
                    }
                    MaidKegRecipe maidKegFermentingRecipe = new MaidKegRecipe(fluidItems, (List<Ingredient>)kegFermentingRecipe.m_7527_());
                    KEG_RECIPE_INGREDIENTS.put(kegFermentingRecipe, maidKegFermentingRecipe);
                    continue;
                }
                MaidKegRecipe maidKegFermentingRecipe = new MaidKegRecipe(Collections.emptyList(), (List<Ingredient>)kegFermentingRecipe.m_7527_());
                KEG_RECIPE_INGREDIENTS.put(kegFermentingRecipe, maidKegFermentingRecipe);
            }
        }
        return KEG_RECIPE_INGREDIENTS.keySet().stream().toList();
    }

    @Override
    public MaidRecipesManager<KegFermentingRecipe> getRecipesManager(EntityMaid maid) {
        return new KegFermentingRecipesManager(maid, this){

            @Override
            protected List<KegFermentingRecipe> getFilterRecipes(List<KegFermentingRecipe> rec) {
                Set<Integer> temperates = TaskBncKeg.this.searchAndCreateTemperate((ServerLevel)this.maid.f_19853_, this.maid);
                return rec.stream().filter(kegFermentingRecipe -> {
                    for (Integer temperate : temperates) {
                        if (!KegBlockEntity.isValidTemp((int)temperate, (int)kegFermentingRecipe.getTemperature())) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
        };
    }

    public ResourceLocation getUid() {
        return TaskInfo.BNC_KEY.uid;
    }

    public ItemStack getIcon() {
        return ((Block)BnCBlocks.KEG.get()).m_5456_().m_7968_();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return DataRegister.BNC_KEY;
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        NonNullList ingredinetNonNullList = NonNullList.m_122779_();
        MaidKegRecipe maidKegRecipe = KEG_RECIPE_INGREDIENTS.get((KegFermentingRecipe)recipe);
        if (!maidKegRecipe.inFluids.isEmpty()) {
            ingredinetNonNullList.add((Object)Ingredient.m_43921_(maidKegRecipe.inFluids.stream()));
        }
        ingredinetNonNullList.addAll(maidKegRecipe.inItems());
        return ingredinetNonNullList;
    }

    protected Set<Integer> searchAndCreateTemperate(ServerLevel worldIn, EntityMaid maid) {
        HashSet<Integer> worldBlockEntityTemperates = new HashSet<Integer>();
        BlockPos centrePos = TaskBncKeg.getSearchPos(maid);
        int searchRange = (int)maid.m_21535_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int y = 0;
        while (y <= 2) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        KegBlockEntity kegBlockEntity;
                        BlockEntity blockEntity;
                        mutableBlockPos.m_122154_((Vec3i)centrePos, x, y + 1, z);
                        if (maid.m_21444_((BlockPos)mutableBlockPos) && (blockEntity = worldIn.m_7702_((BlockPos)mutableBlockPos)) instanceof KegBlockEntity && !((ICbeAccessor)(kegBlockEntity = (KegBlockEntity)blockEntity)).tlmk$innerCanCook()) {
                            worldBlockEntityTemperates.add(kegBlockEntity.getTemperature());
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        return worldBlockEntityTemperates;
    }

    protected void pickupAction(EntityMaid maid) {
        maid.m_6674_(InteractionHand.MAIN_HAND);
        maid.m_5496_(SoundEvents.f_12019_, 1.0f, maid.m_217043_().m_188501_() * 0.1f + 1.0f);
    }

    public record MaidKegRecipe(List<ItemStack> inFluids, List<Ingredient> inItems) {
    }
}

