/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.barbequesdelight;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.barbequesdelight.MaidGrillMakeTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.MaidCookMoveTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.github.wallev.verhelper.server.ai.VBehaviorControl;
import com.google.common.collect.Lists;
import com.mao.barbequesdelight.content.block.GrillBlockEntity;
import com.mao.barbequesdelight.content.recipe.GrillingRecipe;
import com.mao.barbequesdelight.content.recipe.SimpleGrillingRecipe;
import com.mao.barbequesdelight.init.registrate.BBQDBlocks;
import com.mao.barbequesdelight.init.registrate.BBQDItems;
import com.mao.barbequesdelight.init.registrate.BBQDRecipes;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TaskBdGrill
implements ICookTask<GrillBlockEntity, GrillingRecipe<?>> {
    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof GrillBlockEntity;
    }

    @Override
    public RecipeType<GrillingRecipe<?>> getRecipeType() {
        return (RecipeType)BBQDRecipes.RT_BBQ.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, GrillBlockEntity blockEntity, MaidRecipesManager<GrillingRecipe<?>> recManager) {
        GrillBlockEntity.ItemEntry[] itemEntries;
        boolean innerCanCook = false;
        for (GrillBlockEntity.ItemEntry itemEntry : itemEntries = blockEntity.entries) {
            if (itemEntry.stack.m_150930_(BBQDItems.BURNT_FOOD.m_5456_())) {
                return true;
            }
            if (itemEntry.stack.m_41619_()) continue;
            if (itemEntry.canFlip()) {
                return true;
            }
            if (itemEntry.flipped && itemEntry.time >= itemEntry.duration) {
                return true;
            }
            innerCanCook = true;
        }
        return blockEntity.isHeated() && !innerCanCook && !recManager.getRecipesIngredients().isEmpty();
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, GrillBlockEntity blockEntity, MaidRecipesManager<GrillingRecipe<?>> recManager) {
    }

    @Override
    public List<Pair<Integer, VBehaviorControl>> vCreateBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Collections.emptyList();
        }
        MaidRecipesManager<GrillingRecipe<?>> cookingPotRecipeMaidRecipesManager = this.getRecipesManager(maid);
        MaidCookMoveTask maidCookMoveTask = new MaidCookMoveTask(this, cookingPotRecipeMaidRecipesManager);
        MaidGrillMakeTask maidGrillMakeTask = new MaidGrillMakeTask(this, cookingPotRecipeMaidRecipesManager);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidCookMoveTask), Pair.of((Object)6, (Object)maidGrillMakeTask)});
    }

    public ResourceLocation getUid() {
        return TaskInfo.BD_GRILL.uid;
    }

    public ItemStack getIcon() {
        return BBQDBlocks.GRILL.asStack();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return DataRegister.BD_GRILL;
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        NonNullList ingredients = NonNullList.m_122779_();
        SimpleGrillingRecipe simpleGrillingRecipe = (SimpleGrillingRecipe)recipe;
        ingredients.add((Object)simpleGrillingRecipe.ingredient);
        return ingredients;
    }

    @Override
    public ItemStack getResultItem(Recipe<?> recipe, RegistryAccess pRegistryAccess) {
        return ICookTask.super.getResultItem(recipe, pRegistryAccess);
    }
}

