/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.api.task.cook;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.IContainerCook;
import com.github.wallev.maidsoulkitchen.api.task.cook.IContainerCookBe;
import com.github.wallev.maidsoulkitchen.entity.passive.IMaidsoulKitchenMaid;
import com.github.wallev.maidsoulkitchen.task.cook.common.bestate.IHeatBe;
import com.github.wallev.maidsoulkitchen.task.cook.common.inventory.MaidRecipesManager;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public interface IBaseContainerPotCook<B extends BlockEntity, R extends Recipe<? extends Container>>
extends IHeatBe<B>,
IContainerCookBe<B>,
IContainerCook {
    default public boolean maidShouldMoveTo(ServerLevel serverLevel, EntityMaid entityMaid, B blockEntity, MaidRecipesManager<R> maidRecipesManager) {
        Container inventory = this.getContainer(blockEntity);
        if (this.canTakeOutput(inventory, blockEntity)) {
            return true;
        }
        boolean heated = this.isHeated(blockEntity);
        boolean b = this.beInnerCanCook(inventory, blockEntity);
        List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients = maidRecipesManager.getRecipesIngredients();
        if (!b && !recipesIngredients.isEmpty() && heated) {
            return true;
        }
        return this.inputCanTake(b, inventory);
    }

    default public boolean inputCanTake(boolean beInnerCanCook, Container inventory) {
        return !beInnerCanCook && this.hasInput(inventory);
    }

    default public boolean canTakeOutput(Container inventory, B be) {
        return !inventory.m_8020_(this.getOutputSlot()).m_41619_();
    }

    default public void maidCookMake(ServerLevel serverLevel, EntityMaid entityMaid, B blockEntity, MaidRecipesManager<R> maidRecipesManager) {
        this.tryExtractItem(serverLevel, entityMaid, blockEntity, maidRecipesManager);
        this.tryInsertItem(serverLevel, entityMaid, blockEntity, maidRecipesManager);
        maidRecipesManager.getCookInv().syncInv();
    }

    default public void tryExtractItem(ServerLevel serverLevel, EntityMaid entityMaid, B blockEntity, MaidRecipesManager<R> maidRecipesManager) {
        Container inventory = this.getContainer(blockEntity);
        this.extractOutputStack(inventory, maidRecipesManager.getOutputInv(), (BlockEntity)blockEntity);
        boolean heated = this.isHeated(blockEntity);
        boolean b = this.beInnerCanCook(inventory, blockEntity);
        if (this.inputCanTake(b, inventory)) {
            this.extractInputStack(inventory, maidRecipesManager.getInputInv(), (BlockEntity)blockEntity);
        }
        IMaidsoulKitchenMaid.pickupAction(entityMaid);
    }

    default public void tryInsertItem(ServerLevel serverLevel, EntityMaid entityMaid, B blockEntity, MaidRecipesManager<R> maidRecipesManager) {
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
        Container inventory = this.getContainer(blockEntity);
        Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = maidRecipesManager.getRecipeIngredient();
        if (this.hasInput(inventory) || ((List)recipeIngredient.getFirst()).isEmpty()) {
            return;
        }
        this.insertInputStack(inventory, (IItemHandlerModifiable)availableInv, (BlockEntity)blockEntity, recipeIngredient);
        IMaidsoulKitchenMaid.pickupAction(entityMaid);
    }

    public boolean beInnerCanCook(Container var1, B var2);
}

