/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.util.contract.ContractInProgress;
import org.jetbrains.annotations.Nullable;

public class ContractItem
extends Item {
    public static final String TAG_PLAYER = "player_uuid";
    public static final String TAG_CONTRACT_ID = "contract_id";
    public static final String TAG_NAME = "contract_name";
    public static final String TAG_DESCRIPTION = "contract_description";
    public static final String TAG_COUNT_LEFT = "count_left";
    public static final String TAG_COUNT_TOTAL = "count_total";
    public static final String TAG_EXPIRY_TICK = "expiry_tick";

    public ContractItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (itemStack.m_41783_() == null) {
            list.add((Component)Component.m_237115_((String)"tooltip.wildernature.contract_error"));
            return;
        }
        MutableComponent name = Component.m_237115_((String)itemStack.m_41783_().m_128461_(TAG_NAME));
        MutableComponent description = Component.m_237115_((String)itemStack.m_41783_().m_128461_(TAG_DESCRIPTION));
        MutableComponent progress = Component.m_237110_((String)"text.gui.wildernature.bounty.progress", (Object[])new Object[]{itemStack.m_41783_().m_128451_(TAG_COUNT_TOTAL) - itemStack.m_41783_().m_128451_(TAG_COUNT_LEFT), itemStack.m_41783_().m_128451_(TAG_COUNT_TOTAL)});
        list.add((Component)name);
        list.add((Component)description);
        list.add((Component)progress);
        if (itemStack.m_41783_().m_128441_(TAG_EXPIRY_TICK) && level != null) {
            long currentTick;
            long expiryTick = itemStack.m_41783_().m_128454_(TAG_EXPIRY_TICK);
            long remainingTicks = expiryTick - (currentTick = level.m_46467_());
            if (remainingTicks > 0L) {
                long remainingSeconds = remainingTicks / 20L;
                long minutes = remainingSeconds / 60L;
                long seconds = remainingSeconds % 60L;
                list.add((Component)Component.m_237119_());
                list.add((Component)Component.m_237110_((String)"text.gui.wildernature.bounty.time_remaining", (Object[])new Object[]{minutes, seconds}));
            } else {
                list.add((Component)Component.m_237110_((String)"text.gui.wildernature.bounty.time_remaining", (Object[])new Object[]{0, 0}));
            }
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        if (level.m_5776_() || itemStack.m_41783_() == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_20148_().equals(itemStack.m_41783_().m_128342_(TAG_PLAYER))) {
                return;
            }
            ContractInProgress progress = ContractInProgress.progressPerPlayer.get(player.m_20148_());
            if (progress == null) {
                itemStack.m_41764_(0);
                return;
            }
            itemStack.m_41783_().m_128359_(TAG_CONTRACT_ID, progress.contractResource.toString());
            itemStack.m_41783_().m_128359_(TAG_NAME, progress.getContract().name());
            itemStack.m_41783_().m_128359_(TAG_DESCRIPTION, progress.getContract().description());
            itemStack.m_41783_().m_128405_(TAG_COUNT_TOTAL, progress.getContract().count());
            itemStack.m_41783_().m_128405_(TAG_COUNT_LEFT, progress.count);
        }
    }
}

