/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.DoorInteractGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.entity.ai.RandomAction;
import net.satisfy.wildernature.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaccoonEntity
extends Animal {
    private static final Ingredient FOOD_ITEMS;
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID;
    private static final EntityDataAccessor<Integer> DATA_FLAGS_ID;
    private static final int FLAG_WASHING = 2;
    private static final int FLAG_RUNNING = 256;
    private static final int FLAG_OPENDOOR = 4096;
    public final AnimationState walkState = new AnimationState();
    public final AnimationState runState = new AnimationState();
    public final AnimationState washingState = new AnimationState();
    public final AnimationState openDoorState = new AnimationState();
    public int openDoorAnimationTimeout = 0;
    private int ticksSinceEaten;
    private int washTicks;

    public RaccoonEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.m_20191_().m_82406_(1.0);
        this.m_21573_().m_7008_(true);
        this.m_21573_().m_26575_().m_77355_(true);
        this.m_21573_().m_26575_().m_77351_(true);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.20000001192092895).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22281_, 1.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected void m_8099_() {
        int i = 0;
        this.f_21345_.m_25352_(++i, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(++i, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(++i, (Goal)new RaccoonDoorInteractGoal(this));
        this.f_21345_.m_25352_(++i, new RaccoonAvoidEntityGoal<Player>(this, Player.class));
        this.f_21345_.m_25352_(++i, new RaccoonAvoidEntityGoal<Villager>(this, Villager.class));
        this.f_21345_.m_25352_(++i, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(++i, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(++i, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(++i, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(++i, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(++i, (Goal)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return true;
            }

            @Override
            public void onStop() {
                RaccoonEntity.this.stopWash();
            }

            @Override
            public void onStart() {
                RaccoonEntity.this.startWash();
            }

            @Override
            public boolean isPossible() {
                return !RaccoonEntity.this.isRaccoonRunning();
            }

            @Override
            public int duration() {
                return 48;
            }

            @Override
            public float chance() {
                return 0.01f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return RaccoonEntity.this.m_21051_(movementSpeed);
            }
        }));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.openDoorState.m_246184_(this.isOpeningDoor(), this.f_19797_);
            this.washingState.m_246184_(this.isWashing(), this.f_19797_);
        }
    }

    private boolean isOpeningDoor() {
        return this.getFlag(4096);
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            ++this.ticksSinceEaten;
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.m_6898_(itemStack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemStack2 = itemStack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!itemStack2.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemStack2);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemStack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
        if (this.isDefending() && this.f_19796_.m_188501_() < 0.05f) {
            this.m_5496_((SoundEvent)SoundRegistry.RACCOON_AMBIENT.get(), 1.0f, 1.0f);
        } else {
            this.washTicks = 0;
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6162_() ? entityDimensions.f_20378_ * 0.4f : entityDimensions.f_20378_ * 0.5f;
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return new EntityDimensions(0.1f, 0.1f, false);
    }

    public void m_6210_() {
        super.m_6210_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.RACCOON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.RACCOON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.RACCOON_DEATH.get();
    }

    @Nullable
    public RaccoonEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (RaccoonEntity)((EntityType)EntityRegistry.RACCOON.get()).m_20615_((Level)serverLevel);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    public boolean m_5803_() {
        return this.getFlag(32);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) | i));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~i));
        }
    }

    private boolean getFlag(int i) {
        return ((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) & i) != 0;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public void startWash() {
        this.setFlag(2, true);
    }

    public void stopWash() {
        this.setFlag(2, false);
    }

    public boolean isWashing() {
        return this.getFlag(2);
    }

    public boolean isRaccoonRunning() {
        return this.getFlag(256);
    }

    public void startRunningAnim() {
        this.setFlag(256, true);
    }

    public void stopRunningAnim() {
        this.setFlag(256, false);
    }

    public void startOpenDoorAnim() {
        this.setFlag(4096, true);
    }

    public void stopOpenDoorAnim() {
        this.setFlag(4096, false);
    }

    static {
        DATA_TYPE_ID = SynchedEntityData.m_135353_(RaccoonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_FLAGS_ID = SynchedEntityData.m_135353_(RaccoonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42732_, Items.f_42780_, Items.f_42620_, Items.f_42530_, Items.f_42531_, Items.f_42619_});
    }

    public static class RaccoonDoorInteractGoal
    extends DoorInteractGoal {
        private final RaccoonEntity raccoon;
        public static final AttributeModifier modifier = new AttributeModifier("racoon_door_do_not_move", -1000.0, AttributeModifier.Operation.ADDITION);
        int counter = 0;

        public RaccoonDoorInteractGoal(RaccoonEntity raccoon) {
            super((Mob)raccoon);
            this.raccoon = raccoon;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public void m_8056_() {
            this.counter = 0;
            Objects.requireNonNull(this.raccoon.m_21051_(Attributes.f_22279_)).m_22118_(modifier);
            super.m_8056_();
            this.raccoon.startOpenDoorAnim();
        }

        public boolean m_8045_() {
            return this.counter > 0 && this.counter < ServerAnimationDurations.raccoon_opening_door_length && (!this.m_25200_() || this.counter >= ServerAnimationDurations.raccoon_opening_door_tick);
        }

        public void m_8037_() {
            this.raccoon.m_9236_().m_8055_(this.f_25190_).m_60808_((BlockGetter)this.raccoon.m_9236_().m_46865_(this.f_25190_), this.f_25190_).m_83215_().m_82399_();
            if (this.m_8045_()) {
                this.raccoon.startOpenDoorAnim();
            } else {
                this.raccoon.stopOpenDoorAnim();
            }
            if (this.counter < ServerAnimationDurations.raccoon_opening_door_length) {
                ++this.counter;
            }
            if (this.counter == ServerAnimationDurations.raccoon_opening_door_tick) {
                this.m_25195_(true);
            }
            if (this.counter == ServerAnimationDurations.raccoon_opening_door_length) {
                super.m_8037_();
            }
        }

        public void m_8041_() {
            Objects.requireNonNull(this.raccoon.m_21051_(Attributes.f_22279_)).m_22130_(modifier);
            this.counter = 0;
            super.m_8041_();
            this.m_25195_(true);
            this.raccoon.stopOpenDoorAnim();
        }
    }

    public static class RaccoonAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final RaccoonEntity raccoon;

        public RaccoonAvoidEntityGoal(RaccoonEntity raccoon, Class<T> tClass) {
            super((PathfinderMob)raccoon, tClass, 16.0f, 2.0, 2.0);
            this.raccoon = raccoon;
        }

        public void m_8056_() {
            this.raccoon.startRunningAnim();
            super.m_8056_();
        }

        public void m_8041_() {
            this.raccoon.stopRunningAnim();
            super.m_8041_();
        }
    }
}

