/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeerEntity
extends Animal {
    private static final int FLAG_RUNNING = 256;
    private static final int FLAG_EATING = 65536;
    private static final int FLAG_LOOKING_AROUND = 16;
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_FLAGS_ID = SynchedEntityData.m_135353_(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleState = new AnimationState();
    public final AnimationState lookAroundState = new AnimationState();
    public final AnimationState eatingState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public int globalCooldown = 0;

    public DeerEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.270000011920929).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        int i = 0;
        this.f_21345_.m_25352_(++i, new DeerAvoidEntityGoal<Villager>(this, Villager.class));
        this.f_21345_.m_25352_(++i, new DeerAvoidEntityGoal<Pillager>(this, Pillager.class));
        this.f_21345_.m_25352_(++i, new DeerAvoidEntityGoal<Player>(this, Player.class));
        this.f_21345_.m_25352_(++i, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.15));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41864_}), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new DeerEatingGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new DeerLookAroundGoal(this));
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6162_() ? entityDimensions.f_20378_ * 0.4f : entityDimensions.f_20378_ * 0.5f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.DEER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.DEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.DEER_DEATH.get();
    }

    @Nullable
    public DeerEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (DeerEntity)((EntityType)EntityRegistry.DEER.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_41864_);
    }

    public void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) | i));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~i));
        }
    }

    private boolean getFlag(int i) {
        return ((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) & i) != 0;
    }

    public void startEating() {
        this.setFlag(65536, true);
    }

    public void stopEating() {
        this.setFlag(65536, false);
    }

    public boolean isEating() {
        return this.getFlag(65536);
    }

    public void startLookingAround() {
        this.setFlag(16, true);
    }

    public void stopLookingAround() {
        this.setFlag(16, false);
    }

    public boolean isLookingAround() {
        return this.getFlag(16);
    }

    public boolean isDeerRunning() {
        return this.getFlag(256);
    }

    public void startRunningAnim() {
        this.setFlag(256, true);
    }

    public void stopRunningAnim() {
        this.setFlag(256, false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.globalCooldown > 0) {
            --this.globalCooldown;
        }
        this.eatingState.m_246184_(this.isEating(), this.f_19797_);
        this.lookAroundState.m_246184_(this.isLookingAround(), this.f_19797_);
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    public static class DeerAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final DeerEntity deer;

        public DeerAvoidEntityGoal(DeerEntity deer, Class<T> tClass) {
            super((PathfinderMob)deer, tClass, 16.0f, 2.0, 2.0);
            this.deer = deer;
        }

        public boolean m_8036_() {
            if (this.f_25016_ instanceof Player && this.f_25016_.m_6047_()) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8056_() {
            this.deer.startRunningAnim();
            super.m_8056_();
        }

        public void m_8041_() {
            this.deer.stopRunningAnim();
            super.m_8041_();
        }
    }

    public static class DeerEatingGoal
    extends Goal {
        private final DeerEntity target;
        private int counter;
        private static final int EATING_DURATION_TICKS = 37;
        private static final int COOLDOWN_TICKS = 400;
        public static final AttributeModifier modifier = new AttributeModifier("deer_eat_do_not_move", -1000.0, AttributeModifier.Operation.ADDITION);

        public DeerEatingGoal(DeerEntity mob) {
            this.target = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_6767_() {
            return true;
        }

        public boolean m_8036_() {
            float r = new Random().nextFloat();
            return r < 0.01f && !this.target.isDeerRunning() && this.target.globalCooldown == 0;
        }

        public boolean m_8045_() {
            return this.counter < 37 && !this.target.isDeerRunning();
        }

        public void m_8037_() {
            ++this.counter;
        }

        public void m_8056_() {
            this.counter = 0;
            Objects.requireNonNull(this.target.m_21051_(Attributes.f_22279_)).m_22118_(modifier);
            this.target.startEating();
            super.m_8056_();
        }

        public void m_8041_() {
            Objects.requireNonNull(this.target.m_21051_(Attributes.f_22279_)).m_22130_(modifier);
            this.target.stopEating();
            this.target.globalCooldown = 400;
            super.m_8041_();
        }
    }

    public static class DeerLookAroundGoal
    extends Goal {
        private final DeerEntity target;
        private int counter;
        private static final int LOOK_AROUND_DURATION_TICKS = 70;
        private static final int COOLDOWN_TICKS = 400;
        public static final AttributeModifier modifier = new AttributeModifier("deer_look_around_do_not_move", -1000.0, AttributeModifier.Operation.ADDITION);

        public DeerLookAroundGoal(DeerEntity mob) {
            this.target = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_6767_() {
            return true;
        }

        public boolean m_8036_() {
            float r = new Random().nextFloat();
            return r < 0.01f && !this.target.isDeerRunning() && this.target.globalCooldown == 0;
        }

        public boolean m_8045_() {
            return this.counter < 70 && !this.target.isDeerRunning();
        }

        public void m_8037_() {
            ++this.counter;
        }

        public void m_8056_() {
            this.counter = 0;
            Objects.requireNonNull(this.target.m_21051_(Attributes.f_22279_)).m_22118_(modifier);
            this.target.startLookingAround();
            super.m_8056_();
        }

        public void m_8041_() {
            Objects.requireNonNull(this.target.m_21051_(Attributes.f_22279_)).m_22130_(modifier);
            this.target.stopLookingAround();
            this.target.globalCooldown = 400;
            super.m_8041_();
        }
    }
}

