/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.satisfy.wildernature.entity.DeerEntity;
import net.satisfy.wildernature.entity.animation.DeerAnimation;
import org.jetbrains.annotations.NotNull;

public class DeerModel
extends HierarchicalModel<DeerEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("wildernature", "deer"), "main");
    private final ModelPart deer;
    private final ModelPart head;

    public DeerModel(ModelPart root) {
        this.deer = root.m_171324_("deer");
        this.head = this.deer.m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition deer = partdefinition.m_171599_("deer", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = deer.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -6.0f, 7.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.0f, -4.0f, -9.0f, 10.0f, 9.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(18, 27).m_171488_(-3.0f, -12.0f, -7.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-2.0f, -10.0f, -10.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-2.0f, -7.0f, -5.0f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-7.0f));
        head.m_171599_("horn_right_r1", CubeListBuilder.m_171558_().m_171514_(19, 28).m_171488_(-3.09f, -37.0f, -14.0f, 0.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        head.m_171599_("horn_left_r1", CubeListBuilder.m_171558_().m_171514_(19, 28).m_171488_(2.93f, -37.0f, -14.0f, 0.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        head.m_171599_("left_ear_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171480_().m_171488_(-7.0f, -26.0f, -9.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        head.m_171599_("right_ear_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(4.0f, -26.0f, -9.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        deer.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(38, 5).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)-10.0f, (float)7.5f));
        deer.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(38, 5).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)-10.0f, (float)7.5f));
        deer.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(38, 5).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)-10.0f, (float)-7.5f));
        deer.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(38, 5).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)-10.0f, (float)-7.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(DeerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * 0.008945329f;
        this.head.f_104203_ = headPitch * 0.0047453293f;
        this.m_233385_(entity.idleState, DeerAnimation.idle, ageInTicks, 1.0f);
        if (entity.isDeerRunning()) {
            this.m_267799_(DeerAnimation.run, limbSwing, limbSwingAmount, 1.5f, 2.5f);
        } else {
            this.m_267799_(DeerAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        }
        this.m_233385_(entity.lookAroundState, DeerAnimation.look_around, ageInTicks, 1.0f);
        this.m_233385_(entity.eatingState, DeerAnimation.eat, ageInTicks, 1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.deer.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.deer;
    }
}

