/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.wildernature.block.WallDecorationBlock;
import net.satisfy.wildernature.registry.SoundRegistry;
import net.satisfy.wildernature.util.WilderNatureUtil;
import org.jetbrains.annotations.NotNull;

public class BisonTrophyBlock
extends WallDecorationBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.1875, (double)0.9375, (double)1.0, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)0.125, (double)0.125, (double)0.84375, (double)0.875, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.15625, (double)0.5625, (double)0.375, (double)0.15625, (double)0.75, (double)0.4375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.28125, (double)0.125, (double)-0.1875, (double)0.71875, (double)0.625, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.84375, (double)0.5625, (double)0.375, (double)1.15625, (double)0.75, (double)0.4375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.625, (double)0.5, (double)0.1875, (double)1.25, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.625, (double)0.5, (double)1.0, (double)1.25, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, WilderNatureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });
    private final Map<Player, Long> lastUseTime = new HashMap<Player, Long>();

    public BisonTrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            Long lastUsed;
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastUsed = this.lastUseTime.getOrDefault(player, 0L)) < 180000L) {
                world.m_5594_(null, pos, SoundEvents.f_11739_, SoundSource.BLOCKS, 0.25f, 0.5f);
                return InteractionResult.FAIL;
            }
            this.lastUseTime.put(player, currentTime);
            world.m_5594_(null, pos, (SoundEvent)SoundRegistry.BISON_ANGRY.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            ServerLevel serverLevel = (ServerLevel)world;
            for (int radius = 0; radius <= 20; ++radius) {
                for (int angle = 0; angle < 360; angle += 10) {
                    double radians = Math.toRadians(angle);
                    double offsetX = (double)radius * Math.cos(radians);
                    double offsetZ = (double)radius * Math.sin(radians);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            AABB area = new AABB(pos).m_82400_(20.0);
            List entities = world.m_45976_(LivingEntity.class, area);
            for (LivingEntity entity : entities) {
                if (entity == player) continue;
                double dx = entity.m_20185_() - (double)pos.m_123341_();
                double dz = entity.m_20189_() - (double)pos.m_123343_();
                double distance = Math.sqrt(dx * dx + dz * dz);
                double strength = 2.0 / (distance + 1.0);
                entity.m_147240_(strength, dx, dz);
                entity.m_6469_(world.m_269111_().m_269047_(), 1.0f);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }
}

