/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.renderer.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.meadow.core.block.entity.ModSignBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class ModSignRenderer<T extends ModSignBlockEntity>
implements BlockEntityRenderer<T> {
    private static final String STICK = "stick";
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private static final float RENDER_SCALE = 0.6666667f;
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, 0.3333333432674408, 0.046666666865348816);
    private final Map signModels = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(woodType -> woodType, woodType -> new SignModel(context.m_173582_(ModelLayers.m_171291_((WoodType)woodType)))));
    private final Font font;

    public ModSignRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(ModSignBlockEntity signBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockState blockState = signBlockEntity.m_58900_();
        SignBlock signBlock = (SignBlock)blockState.m_60734_();
        WoodType woodType = SignBlock.m_247329_((Block)signBlock);
        SignModel signModel = (SignModel)((Object)this.signModels.get(woodType));
        signModel.stick.f_104207_ = blockState.m_60734_() instanceof StandingSignBlock;
        this.renderSignWithText(signBlockEntity, poseStack, multiBufferSource, i, j, blockState, signBlock, woodType, signModel);
    }

    public float getSignModelRenderScale() {
        return 0.6666667f;
    }

    public float getSignTextRenderScale() {
        return 0.6666667f;
    }

    void renderSignWithText(ModSignBlockEntity signBlockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, BlockState blockState, SignBlock signBlock, WoodType woodType, Model model) {
        poseStack.m_85836_();
        this.translateSign(poseStack, -signBlock.m_276903_(blockState), blockState);
        this.renderSign(poseStack, multiBufferSource, i, j, woodType, model);
        this.renderSignText(signBlockEntity.m_58899_(), signBlockEntity.m_277142_(), poseStack, multiBufferSource, i, signBlockEntity.m_245065_(), signBlockEntity.m_245123_(), true);
        this.renderSignText(signBlockEntity.m_58899_(), signBlockEntity.m_277159_(), poseStack, multiBufferSource, i, signBlockEntity.m_245065_(), signBlockEntity.m_245123_(), false);
        poseStack.m_85849_();
    }

    void translateSign(PoseStack poseStack, float f, BlockState blockState) {
        poseStack.m_252880_(0.5f, 0.75f * this.getSignModelRenderScale(), 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        if (!(blockState.m_60734_() instanceof StandingSignBlock)) {
            poseStack.m_252880_(0.0f, -0.3125f, -0.4375f);
        }
    }

    void renderSign(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, WoodType woodType, Model model) {
        poseStack.m_85836_();
        float f = this.getSignModelRenderScale();
        poseStack.m_85841_(f, -f, -f);
        Material material = this.getSignMaterial(woodType);
        Objects.requireNonNull(model);
        VertexConsumer vertexConsumer = material.m_119194_(multiBufferSource, arg_0 -> ((Model)model).m_103119_(arg_0));
        this.renderSignModel(poseStack, i, j, model, vertexConsumer);
        poseStack.m_85849_();
    }

    void renderSignModel(PoseStack poseStack, int i, int j, Model model, VertexConsumer vertexConsumer) {
        SignModel signModel = (SignModel)model;
        signModel.root.m_104301_(poseStack, vertexConsumer, i, j);
    }

    Material getSignMaterial(WoodType woodType) {
        return Sheets.m_173381_((WoodType)woodType);
    }

    void renderSignText(BlockPos blockPos, SignText signText, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, int k, boolean bl) {
        int o;
        boolean bl2;
        int n;
        poseStack.m_85836_();
        this.translateSignText(poseStack, bl, this.getTextOffset());
        int l = ModSignRenderer.getDarkColor(signText);
        int m = 4 * j / 2;
        FormattedCharSequence[] formattedCharSequences = signText.m_277130_(Minecraft.m_91087_().m_167974_(), component -> {
            List list = this.font.m_92923_((FormattedText)component, k);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (signText.m_276843_()) {
            n = signText.m_276773_().m_41071_();
            bl2 = ModSignRenderer.isOutlineVisible(blockPos, n);
            o = 0xF000F0;
        } else {
            n = l;
            bl2 = false;
            o = i;
        }
        for (int p = 0; p < 4; ++p) {
            FormattedCharSequence formattedCharSequence = formattedCharSequences[p];
            float f = -this.font.m_92724_(formattedCharSequence) / 2;
            if (bl2) {
                this.font.m_168645_(formattedCharSequence, f, (float)(p * j - m), n, l, poseStack.m_85850_().m_252922_(), multiBufferSource, o);
                continue;
            }
            this.font.m_272191_(formattedCharSequence, f, (float)(p * j - m), n, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, o);
        }
        poseStack.m_85849_();
    }

    private void translateSignText(PoseStack poseStack, boolean bl, Vec3 vec3) {
        if (!bl) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        float f = 0.015625f * this.getSignTextRenderScale();
        poseStack.m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        poseStack.m_85841_(f, -f, f);
    }

    Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }

    static boolean isOutlineVisible(BlockPos blockPos, int i) {
        if (i == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localPlayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)blockPos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    static int getDarkColor(SignText signText) {
        int i = signText.m_276773_().m_41071_();
        if (i == DyeColor.BLACK.m_41071_() && signText.m_276843_()) {
            return -988212;
        }
        double d = 0.4;
        int j = (int)((double)FastColor.ARGB32.m_13665_((int)i) * 0.4);
        int k = (int)((double)FastColor.ARGB32.m_13667_((int)i) * 0.4);
        int l = (int)((double)FastColor.ARGB32.m_13669_((int)i) * 0.4);
        return FastColor.ARGB32.m_13660_((int)0, (int)j, (int)k, (int)l);
    }

    public static SignModel createSignModel(EntityModelSet entityModelSet, WoodType woodType) {
        return new SignModel(entityModelSet.m_171103_(ModelLayers.m_171291_((WoodType)woodType)));
    }

    public static LayerDefinition createSignLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), PartPose.f_171404_);
        partDefinition.m_171599_(STICK, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart stick;

        public SignModel(ModelPart modelPart) {
            super(RenderType::m_110458_);
            this.root = modelPart;
            this.stick = modelPart.m_171324_(ModSignRenderer.STICK);
        }

        public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
            this.root.m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
        }
    }
}

