/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import org.jetbrains.annotations.NotNull;

public class CheeseFormGuiHandler
extends AbstractContainerMenu {
    private final ContainerData propertyDelegate;

    public CheeseFormGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(2));
    }

    public CheeseFormGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get(), syncId);
        this.propertyDelegate = propertyDelegate;
        this.m_38884_(propertyDelegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_((Slot)new FurnaceResultSlot(playerInventory.f_35978_, inventory, 0, 123, 34));
        this.m_38897_(new Slot(inventory, 1, 33, 33));
        this.m_38897_(new Slot(inventory, 2, 51, 33));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getScaledXProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = this.propertyDelegate.m_6413_(1);
        if (progress <= 0 || totalProgress <= 0) {
            return 0;
        }
        return progress * 24 / totalProgress;
    }

    public int getScaledYProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = this.propertyDelegate.m_6413_(1);
        if (progress <= 0 || totalProgress <= 0) {
            return 0;
        }
        return progress * 25 / totalProgress;
    }

    public int getCookingTime() {
        return this.propertyDelegate.m_6413_(0);
    }

    public int getRequiredDuration() {
        return this.propertyDelegate.m_6413_(1);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (index == 0) {
            if (!this.m_38903_(stack, 3, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack, originalStack);
        } else if (index >= 3 && index < this.f_38839_.size() ? !this.m_38903_(stack, 1, 3, false) : index >= 1 && index < 3 && !this.m_38903_(stack, 3, this.f_38839_.size(), false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

