/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.util;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LilisLuckyLuresUtil {
    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = LilisLuckyLuresUtil.registerWithoutItem(registerB, registrarB, name, block);
        LilisLuckyLuresUtil.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static Collection<ServerPlayer> getTrackingPlayers(ServerLevel world, ChunkPos chunkPos) {
        Objects.requireNonNull(world);
        Objects.requireNonNull(chunkPos);
        return world.m_7726_().f_8325_.m_183262_(chunkPos, false);
    }

    public static Collection<ServerPlayer> getTrackingPlayers(ServerLevel world, BlockPos blockPos) {
        Objects.requireNonNull(blockPos);
        return LilisLuckyLuresUtil.getTrackingPlayers(world, new ChunkPos(blockPos));
    }

    public static Optional<Tuple<Float, Float>> getRelativeHitCoordinatesForBlockFace(BlockHitResult blockHitResult, Direction direction, Direction[] unAllowedDirections) {
        Direction hitDirection = blockHitResult.m_82434_();
        for (Direction unAllowed : unAllowedDirections) {
            if (unAllowed != hitDirection) continue;
            return Optional.empty();
        }
        if (hitDirection != direction && hitDirection != Direction.UP && hitDirection != Direction.DOWN) {
            return Optional.empty();
        }
        BlockPos adjacentPos = blockHitResult.m_82425_().m_121945_(hitDirection);
        Vec3 hitLocation = blockHitResult.m_82450_().m_82492_((double)adjacentPos.m_123341_(), (double)adjacentPos.m_123342_(), (double)adjacentPos.m_123343_());
        float x = (float)hitLocation.m_7096_();
        float z = (float)hitLocation.m_7094_();
        float y = (float)hitLocation.m_7098_();
        Direction effectiveDirection = hitDirection == Direction.UP || hitDirection == Direction.DOWN ? direction : hitDirection;
        return switch (effectiveDirection) {
            case Direction.NORTH -> Optional.of(new Tuple((Object)Float.valueOf(1.0f - x), (Object)Float.valueOf(y)));
            case Direction.SOUTH -> Optional.of(new Tuple((Object)Float.valueOf(x), (Object)Float.valueOf(y)));
            case Direction.WEST -> Optional.of(new Tuple((Object)Float.valueOf(z), (Object)Float.valueOf(y)));
            case Direction.EAST -> Optional.of(new Tuple((Object)Float.valueOf(1.0f - z), (Object)Float.valueOf(y)));
            default -> Optional.empty();
        };
    }
}

