/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.lilis_lucky_lures.core.recipe.FishTrapRecipe;
import net.satisfy.lilis_lucky_lures.core.recipe.SimpleConditionalRecipe;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;

public class RecipeTypeRegistry {
    private static final Registrar<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.f_256954_).getRegistrar();
    private static final Registrar<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.f_256764_).getRegistrar();
    public static final RegistrySupplier<RecipeType<FishTrapRecipe>> FISH_TRAP_RECIPE_TYPE = RecipeTypeRegistry.create("fish_trap");
    public static final RegistrySupplier<RecipeSerializer<FishTrapRecipe>> FISH_TRAP_RECIPE_SERIALIZER = RecipeTypeRegistry.create("fish_trap", FishTrapRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeSerializer<Recipe<?>>> CONDITIONAL_RECIPE_SERIALIZER = RecipeTypeRegistry.create("conditional", SimpleConditionalRecipe.Serializer::new);

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> create(String name, Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register((ResourceLocation)new LilisLuckyLuresIdentifier(name), serializer);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> create(final String name) {
        Supplier<RecipeType> type = () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        };
        return RECIPE_TYPES.register((ResourceLocation)new LilisLuckyLuresIdentifier(name), type);
    }

    public static void init() {
    }
}

