/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishNetBlockItem
extends Item {
    private static final String MODE_KEY = "FishingNetMode";
    private final Block netBlock;
    private final Block fenceBlock;

    public FishNetBlockItem(Item.Properties properties, Block netBlock, Block fenceBlock) {
        super(properties);
        this.netBlock = netBlock;
        this.fenceBlock = fenceBlock;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPlaceContext placeContext;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            if (!level.f_46443_) {
                this.toggleMode(stack, (ServerLevel)level, player);
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        String mode = this.getMode(stack);
        Block targetBlock = mode.equals("fence") ? this.fenceBlock : this.netBlock;
        BlockState state = targetBlock.m_5573_(placeContext = new BlockPlaceContext(context));
        if (state == null || !state.m_60710_((LevelReader)level, pos)) {
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_) {
            level.m_7731_(pos, state, 3);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.f_46443_) {
                this.toggleMode(stack, (ServerLevel)level, player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void toggleMode(ItemStack stack, ServerLevel level, Player player) {
        String mode = this.getMode(stack);
        String newMode = mode.equals("net") ? "fence" : "net";
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(MODE_KEY, newMode);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (newMode.equals("net")) {
            tag.m_128405_("CustomModelData", 0);
        } else {
            tag.m_128405_("CustomModelData", 1);
        }
        stack.m_41751_(tag);
    }

    private String getMode(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(MODE_KEY) ? tag.m_128461_(MODE_KEY) : "net";
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        Style actionStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)16772275));
        Style descriptionStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)5415884));
        MutableComponent combinedText = Component.m_237113_((String)"[").m_6270_(actionStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.item.fish_net.action").m_6270_(actionStyle)).m_7220_((Component)Component.m_237113_((String)"] ").m_6270_(actionStyle)).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.item.fish_net.description").m_6270_(descriptionStyle));
        tooltip.add((Component)combinedText);
    }
}

