/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class DynamiteEntity
extends ThrowableItemProjectile {
    private static final float EXPLOSION_RADIUS = 1.5f;
    private static final float DAMPING_FACTOR = 0.2f;
    private static final double MIN_VELOCITY = 0.2;
    private static final int SMOKE_DURATION = 100;
    private static final float EXTRA_DAMAGE = 2.0f;
    private int bounceCount;
    private int smokeTicksRemaining = 0;

    public DynamiteEntity(Level world, LivingEntity owner) {
        super((EntityType)EntityTypeRegistry.DYNAMITE.get(), owner, world);
    }

    public DynamiteEntity(EntityType<? extends DynamiteEntity> entityType, Level world) {
        super(entityType, world);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ObjectRegistry.DYNAMITE.get();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    private ParticleOptions getParticle() {
        ItemStack stack = this.m_37454_();
        return stack.m_41619_() ? ParticleTypes.f_123762_ : new ItemParticleOption(ParticleTypes.f_123752_, stack);
    }

    public void m_7822_(byte event) {
        if (event == 3) {
            double speed;
            double z;
            double y;
            double x;
            double phi;
            double theta;
            int i;
            ParticleOptions itemParticle = this.getParticle();
            for (i = 0; i < 6; ++i) {
                theta = this.f_19796_.m_188500_() * 2.0 * Math.PI;
                phi = Math.acos(2.0 * this.f_19796_.m_188500_() - 1.0);
                x = Math.sin(phi) * Math.cos(theta);
                y = Math.sin(phi) * Math.sin(theta);
                z = Math.cos(phi);
                speed = 0.5;
                this.m_9236_().m_7106_(itemParticle, this.m_20185_(), this.m_20186_(), this.m_20189_(), x * speed, y * speed, z * speed);
            }
            for (i = 0; i < 4; ++i) {
                theta = this.f_19796_.m_188500_() * 2.0 * Math.PI;
                phi = Math.acos(2.0 * this.f_19796_.m_188500_() - 1.0);
                x = Math.sin(phi) * Math.cos(theta);
                y = Math.sin(phi) * Math.sin(theta);
                z = Math.cos(phi);
                speed = 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), x * speed, y * speed, z * speed);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), x * speed, y * speed, z * speed);
            }
            this.smokeTicksRemaining = 100;
        } else {
            super.m_7822_(event);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.m_20184_().m_82553_() < 0.2 && this.bounceCount > 0 && !this.m_9236_().f_46443_) {
            this.explode();
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
        if (this.smokeTicksRemaining > 0) {
            if (this.m_9236_().f_46443_) {
                double height = 6.0;
                for (int i = 0; i < 5; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    double posY = this.m_20186_() + height * (1.0 - (double)this.smokeTicksRemaining / 100.0) + this.f_19796_.m_188500_() * 0.2;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + offsetX, posY, this.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
                }
            }
            --this.smokeTicksRemaining;
            if (this.smokeTicksRemaining <= 0) {
                this.m_146870_();
            }
        }
    }

    protected void m_6532_(HitResult result) {
        if (this.bounceCount >= 1 || this.f_19797_ >= 160) {
            if (!this.m_9236_().f_46443_) {
                this.explode();
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_146870_();
            }
        } else {
            ++this.bounceCount;
            super.m_6532_(result);
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        double vx = this.m_20184_().f_82479_;
        double vy = this.m_20184_().f_82480_;
        double vz = this.m_20184_().f_82481_;
        Direction d = hit.m_82434_();
        BlockPos pos = hit.m_82425_();
        if (this.m_9236_().m_8055_(pos).m_280555_()) {
            if (!this.m_9236_().f_46443_ && this.bounceCount < 2) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12634_, SoundSource.NEUTRAL, 1.0f, 4.0f);
            }
            if (d == Direction.EAST || d == Direction.WEST) {
                vx = -vx * (double)0.2f;
            }
            if (d == Direction.DOWN || d == Direction.UP) {
                vy = -vy * (double)0.2f;
            }
            if (d == Direction.NORTH || d == Direction.SOUTH) {
                vz = -vz * (double)0.2f;
            }
            this.m_20334_(vx, vy, vz);
        }
    }

    protected void m_5790_(EntityHitResult hit) {
        double vx = this.m_20184_().f_82479_;
        double vy = this.m_20184_().f_82480_;
        double vz = this.m_20184_().f_82481_;
        double ax = Math.abs(vx);
        double ay = Math.abs(vy);
        double az = Math.abs(vz);
        if (ax >= ay && ax >= az) {
            vx = -vx * (double)0.2f;
        } else if (ay >= ax && ay >= az) {
            vy = -vy * (double)0.2f;
        } else {
            vz = -vz * (double)0.2f;
        }
        this.m_20334_(vx, vy, vz);
    }

    public void m_37251_(Entity entity, float x, float y, float z, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(y * ((float)Math.PI / 180))) * Mth.m_14089_((float)(x * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(y * ((float)Math.PI / 180))) * Mth.m_14089_((float)(x * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
        this.m_20256_(this.m_20184_().m_82542_((double)0.7f, 0.5, (double)0.7f));
        Vec3 v = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(v.f_82479_, entity.m_20096_() ? 0.0 : v.f_82480_, v.f_82481_));
    }

    protected void explode() {
        boolean underwater = this.m_20069_();
        float radius = underwater ? 4.5f : 1.5f;
        Level.ExplosionInteraction interaction = underwater ? Level.ExplosionInteraction.NONE : Level.ExplosionInteraction.TNT;
        this.m_9236_().m_254849_((Entity)this, (double)((float)this.m_20185_()), (double)((float)(this.m_20227_(0.0625) + 0.5)), (double)((float)this.m_20189_()), radius, interaction);
        Vector3d center = new Vector3d(this.m_20185_(), this.m_20227_(0.0625) + 0.5, this.m_20189_());
        AABB aabb = new AABB(center.x - (double)radius, center.y - (double)radius, center.z - (double)radius, center.x + (double)radius, center.y + (double)radius, center.z + (double)radius);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, aabb)) {
            if (entity == this.m_19749_()) continue;
            entity.m_6469_(this.m_9236_().m_269111_().m_269093_(null), 2.0f);
        }
    }
}

