/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.satisfy.lilis_lucky_lures.core.block.RedstoneCoilBlock;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class RedstoneCoilBlockEntity
extends BlockEntity {
    private static final Random RANDOM = new Random();
    private BlockPos targetPos = null;
    private int beamProgress = 0;
    private int tickCounter = 0;
    private int phase = 0;
    private UUID owner = null;

    public RedstoneCoilBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.REDSTONE_COIL.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128403_("Owner")) {
            this.owner = tag.m_128342_("Owner");
        }
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setActive(boolean active) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)RedstoneCoilBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RedstoneCoilBlockEntity be) {
        ServerLevel serverLevel;
        block33: {
            block32: {
                if (!(level instanceof ServerLevel)) break block32;
                serverLevel = (ServerLevel)level;
                if (((Boolean)state.m_61143_((Property)RedstoneCoilBlock.ACTIVE)).booleanValue()) break block33;
            }
            return;
        }
        ++be.tickCounter;
        if (be.tickCounter >= 200) {
            be.tickCounter = 0;
            int range = Math.min(32, Math.max(3, serverLevel.m_277086_(pos)));
            AABB box = new AABB(pos).m_82400_((double)range);
            List entities = serverLevel.m_6443_(LivingEntity.class, box, LivingEntity::m_6084_);
            RedstoneCoilBlock.RedstoneCoilTarget targetMode = (RedstoneCoilBlock.RedstoneCoilTarget)((Object)state.m_61143_(RedstoneCoilBlock.TARGET));
            ArrayList<LivingEntity> filtered = new ArrayList<LivingEntity>();
            switch (targetMode) {
                case NONE: {
                    break;
                }
                case FISHES: {
                    for (LivingEntity entity : entities) {
                        if (!entity.m_20069_()) continue;
                        filtered.add(entity);
                    }
                    break;
                }
                case PLAYER: {
                    Iterator ownerPlayer = be.owner != null ? serverLevel.m_46003_(be.owner) : null;
                    for (LivingEntity entity : entities) {
                        Player p2;
                        if (!(entity instanceof Player) || (p2 = (Player)entity).m_7500_() || ownerPlayer != null && (p2.m_20148_().equals(ownerPlayer.m_20148_()) || ownerPlayer.m_5647_() != null && p2.m_5647_() != null && ownerPlayer.m_5647_().m_83536_(p2.m_5647_()))) continue;
                        filtered.add(entity);
                    }
                    break;
                }
                case MONSTER: {
                    for (LivingEntity entity : entities) {
                        if (entity.m_6095_().m_20674_() != MobCategory.MONSTER) continue;
                        filtered.add(entity);
                    }
                    break;
                }
            }
            if (!filtered.isEmpty()) {
                LivingEntity target = (LivingEntity)filtered.get(0);
                be.targetPos = target.m_20183_();
                be.beamProgress = 0;
                be.phase = 1;
                serverLevel.m_5594_(null, pos, SoundEvents.f_11867_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (be.phase == 1 && be.beamProgress < 30) {
            double radius = (1.0 - (double)be.beamProgress / 30.0) * 2.0;
            for (int i = 0; i < 5; ++i) {
                double angle = serverLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                double x = (double)pos.m_123341_() + 0.5 + radius * Math.cos(angle);
                double y = (double)pos.m_123342_() + 1.0 + serverLevel.f_46441_.m_188500_();
                double z = (double)pos.m_123343_() + 0.5 + radius * Math.sin(angle);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            ++be.beamProgress;
            if (be.beamProgress >= 30) {
                be.beamProgress = 0;
                be.phase = 2;
            }
        }
        if (be.phase == 2 && be.beamProgress < 20 && be.targetPos != null) {
            if (be.beamProgress == 0) {
                serverLevel.m_5594_(null, pos, SoundEvents.f_11923_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ++be.beamProgress;
            double progress = (double)be.beamProgress / 20.0;
            Vector3d start = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
            Vector3d end = new Vector3d((double)be.targetPos.m_123341_() + 0.5, (double)be.targetPos.m_123342_() + 0.5, (double)be.targetPos.m_123343_() + 0.5);
            Vector3d dir = new Vector3d((Vector3dc)end).sub((Vector3dc)start);
            Vector3d current = new Vector3d((Vector3dc)dir).mul(progress).add((Vector3dc)start);
            Vector3d arbitrary = new Vector3d(0.0, 1.0, 0.0);
            if (Math.abs(dir.dot((Vector3dc)arbitrary)) > 0.99) {
                arbitrary.set(1.0, 0.0, 0.0);
            }
            Vector3d perp = new Vector3d();
            dir.cross((Vector3dc)arbitrary, perp).normalize();
            double wave = Math.sin(progress * Math.PI * 4.0) * 0.1;
            perp.mul(wave);
            current.add((Vector3dc)perp);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            if (be.beamProgress >= 20) {
                List targets = serverLevel.m_6443_(LivingEntity.class, new AABB(be.targetPos).m_82400_(1.0), LivingEntity::m_6084_);
                if (!targets.isEmpty()) {
                    Player player;
                    LivingEntity livingTarget = (LivingEntity)targets.get(0);
                    if (livingTarget instanceof Player && (player = (Player)livingTarget).m_21254_()) {
                        boolean offShield;
                        boolean mainShield = !player.m_21205_().m_41619_() && player.m_21205_().m_41720_() instanceof ShieldItem;
                        boolean bl = offShield = !player.m_21206_().m_41619_() && player.m_21206_().m_41720_() instanceof ShieldItem;
                        if (mainShield || offShield) {
                            Vector3d shieldPos;
                            InteractionHand hand;
                            ItemStack shieldStack;
                            if (mainShield) {
                                shieldStack = player.m_21205_();
                                hand = InteractionHand.MAIN_HAND;
                            } else {
                                shieldStack = player.m_21206_();
                                hand = InteractionHand.OFF_HAND;
                            }
                            int shieldDamage = serverLevel.f_46441_.m_188503_(10) + 4;
                            shieldStack.m_41622_(shieldDamage, (LivingEntity)player, p -> p.m_21190_(hand));
                            Vector3d look = new Vector3d(player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_);
                            Vector3d right = new Vector3d();
                            new Vector3d(0.0, 1.0, 0.0).cross((Vector3dc)look, right).normalize();
                            if (hand == InteractionHand.MAIN_HAND) {
                                shieldPos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_() - 0.5, player.m_20189_());
                                shieldPos.add((Vector3dc)look.mul(0.3)).add((Vector3dc)right.mul(0.4));
                            } else {
                                shieldPos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_() - 0.5, player.m_20189_());
                                shieldPos.add((Vector3dc)look.mul(0.3)).sub((Vector3dc)right.mul(0.4));
                            }
                            int flashCount = serverLevel.f_46441_.m_188503_(2) + 2;
                            for (int i = 0; i < flashCount; ++i) {
                                double flashX = shieldPos.x + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2;
                                double flashY = shieldPos.y + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2;
                                double flashZ = shieldPos.z + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2;
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, flashX, flashY, flashZ, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            for (LivingEntity entity : serverLevel.m_6443_(LivingEntity.class, new AABB(shieldPos.x, shieldPos.y, shieldPos.z, shieldPos.x, shieldPos.y, shieldPos.z).m_82400_(10.0), LivingEntity::m_6084_)) {
                                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
                            }
                        } else {
                            RedstoneCoilBlockEntity.applyDamage(livingTarget, serverLevel, be);
                        }
                    } else {
                        RedstoneCoilBlockEntity.applyDamage(livingTarget, serverLevel, be);
                    }
                }
                be.phase = 0;
                be.targetPos = null;
                be.beamProgress = 0;
            }
        }
    }

    private static void applyDamage(LivingEntity livingTarget, ServerLevel serverLevel, RedstoneCoilBlockEntity be) {
        float damage = 10.0f;
        if (livingTarget.m_20069_()) {
            damage *= 1.65f;
        }
        boolean hasIronArmor = false;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ArmorItem armorItem;
            Item item;
            ItemStack armorStack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armorStack = livingTarget.m_6844_(slot)).m_41619_() || !((item = armorStack.m_41720_()) instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != ArmorMaterials.IRON) continue;
            hasIronArmor = true;
            int armorDamage = serverLevel.f_46441_.m_188503_(5) + 3;
            armorStack.m_41622_(armorDamage, livingTarget, e -> e.m_21166_(slot));
        }
        if (hasIronArmor) {
            damage *= 1.12f;
        }
        livingTarget.m_6469_(serverLevel.m_269111_().m_269425_(), damage);
        livingTarget.m_20254_(5);
        RedstoneCoilBlockEntity.setFireAround(serverLevel, be.targetPos);
        RedstoneCoilBlockEntity.spawnImpactParticles(serverLevel, be.targetPos);
    }

    private static void setFireAround(ServerLevel level, BlockPos center) {
        for (int x = center.m_123341_() - 3; x <= center.m_123341_() + 3; ++x) {
            for (int y = center.m_123342_() - 3; y <= center.m_123342_() + 3; ++y) {
                for (int z = center.m_123343_() - 3; z <= center.m_123343_() + 3; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockPos abovePos = currentPos.m_7494_();
                    if (level.m_8055_(currentPos).m_60795_() || !level.m_46859_(abovePos) || !(RANDOM.nextDouble() < 0.05)) continue;
                    level.m_7731_(abovePos, Blocks.f_50083_.m_49966_(), 3);
                }
            }
        }
    }

    private static void spawnImpactParticles(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 40; ++i) {
            Vector3d vec = new Vector3d(level.f_46441_.m_188500_() * 2.0 - 1.0, level.f_46441_.m_188500_() * 2.0 - 1.0, level.f_46441_.m_188500_() * 2.0 - 1.0);
            if (vec.lengthSquared() == 0.0) continue;
            vec.normalize().mul(level.f_46441_.m_188500_() * 1.5 + 0.5);
            double particleX = (double)pos.m_123341_() + 0.5;
            double particleY = (double)pos.m_123342_() + 0.5;
            double particleZ = (double)pos.m_123343_() + 0.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, particleX, particleY, particleZ, 0, vec.x, vec.y, vec.z, 0.2);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, particleX, particleY, particleZ, 0, vec.x * 1.2, vec.y * 1.2, vec.z * 1.2, 0.1);
        }
    }
}

