/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.lilis_lucky_lures.core.block.FishTrapBlock;
import net.satisfy.lilis_lucky_lures.core.recipe.FishTrapRecipe;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class FishTrapBlockEntity
extends BlockEntity
implements WorldlyContainer,
Clearable {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private int timer = 0;
    private int duration = 0;
    private boolean processing = false;
    private FishTrapRecipe recipe;

    public FishTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FISH_TRAP.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack inputItem = (ItemStack)this.inventory.get(0);
            if (this.recipe == null && !inputItem.m_41619_()) {
                SimpleContainer container = new SimpleContainer(1);
                container.m_6836_(0, inputItem);
                RecipeManager recipeManager = this.f_58857_.m_7465_();
                Recipe currentRecipe = recipeManager.m_44015_((RecipeType)RecipeTypeRegistry.FISH_TRAP_RECIPE_TYPE.get(), (Container)container, this.f_58857_).orElse(null);
                if (currentRecipe instanceof FishTrapRecipe) {
                    FishTrapRecipe fishTrapRecipe;
                    this.recipe = fishTrapRecipe = (FishTrapRecipe)currentRecipe;
                }
            }
            if (this.recipe == null || inputItem.m_41619_()) {
                this.processing = false;
                this.timer = 0;
                return;
            }
            if (this.processing) {
                ++this.timer;
                if (this.timer >= this.duration) {
                    this.processing = false;
                    this.timer = 0;
                    ItemStack stack = (ItemStack)this.inventory.get(0);
                    if (!stack.m_41619_()) {
                        stack.m_41774_(1);
                        if (stack.m_41613_() <= 0) {
                            this.inventory.set(0, (Object)ItemStack.f_41583_);
                        }
                    }
                    this.addCatchToOutput();
                    this.recipe = null;
                    this.m_6596_();
                }
            } else if (this.recipe.getBaitItem().test(inputItem)) {
                this.processing = true;
                this.duration = this.recipe.getRandomDuration();
            }
            this.updateBlockState();
        }
    }

    private void addCatchToOutput() {
        ItemStack output = this.recipe.getCatchItem().m_41777_();
        output.m_41764_(this.recipe.getCatchCount());
        ItemStack existingOutput = (ItemStack)this.inventory.get(1);
        if (existingOutput.m_41619_()) {
            this.inventory.set(1, (Object)output);
        } else if (ItemStack.m_150942_((ItemStack)existingOutput, (ItemStack)output)) {
            existingOutput.m_41769_(output.m_41613_());
            this.inventory.set(1, (Object)existingOutput);
        }
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.f_58857_ != null) {
            boolean isFull = !((ItemStack)this.inventory.get(1)).m_41619_();
            boolean hasBait = !((ItemStack)this.inventory.get(0)).m_41619_();
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Block block = state.m_60734_();
            if (block instanceof FishTrapBlock) {
                FishTrapBlock fishTrapBlock = (FishTrapBlock)block;
                fishTrapBlock.updateBlockState(this.f_58857_, this.f_58858_, isFull, hasBait);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.timer = tag.m_128451_("Timer");
        this.duration = tag.m_128451_("Duration");
        this.processing = tag.m_128471_("Processing");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        tag.m_128405_("Timer", this.timer);
        tag.m_128405_("Duration", this.duration);
        tag.m_128379_("Processing", this.processing);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack removed = ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
        this.m_6596_();
        this.updateBlockState();
        return removed;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack removed = ContainerHelper.m_18966_(this.inventory, (int)slot);
        this.m_6596_();
        this.updateBlockState();
        return removed;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.m_6596_();
        this.updateBlockState();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.inventory.clear();
        this.recipe = null;
        this.m_6596_();
        this.updateBlockState();
    }

    public int @NotNull [] m_7071_(Direction direction) {
        return new int[]{0, 1};
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction direction) {
        return slot == 0 && this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return slot == 1;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 0) {
            SimpleContainer container = new SimpleContainer(new ItemStack[]{stack});
            return this.f_58857_ != null && this.f_58857_.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.FISH_TRAP_RECIPE_TYPE.get(), (Container)container, this.f_58857_).isPresent();
        }
        return false;
    }
}

