/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.lilis_lucky_lures.core.block.FishNetFenceBlock;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrapBlockEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishTrapBlock
extends BaseEntityBlock {
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    public static final BooleanProperty HAS_BAIT = BooleanProperty.m_61465_((String)"has_bait");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HANGING = BooleanProperty.m_61465_((String)"hanging");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final TagKey<Block> ROPES = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new LilisLuckyLuresIdentifier("ropes"));
    private static final VoxelShape SHAPE_NORMAL = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);
    private static final VoxelShape SHAPE_HANGING = Shapes.m_83048_((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375);

    public FishTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_BAIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FULL, HAS_BAIT, WATERLOGGED, HANGING, FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean hanging = this.isHanging((LevelAccessor)level, pos.m_7494_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP) {
            boolean hanging = this.isHanging(level, pos.m_7494_());
            return (BlockState)state.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (fromPos.equals((Object)pos.m_7494_())) {
            boolean hanging = this.isHanging((LevelAccessor)level, pos.m_7494_());
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hanging)), 3);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    private boolean isHanging(LevelAccessor level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos);
        return aboveState.m_204336_(ROPES) || aboveState.m_60734_() instanceof FishNetFenceBlock;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? SHAPE_HANGING : SHAPE_NORMAL;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FishTrapBlockEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity fishTrap = (FishTrapBlockEntity)blockEntity;
            if (!level.f_46443_) {
                if (player.m_6144_()) {
                    ItemStack slot0 = fishTrap.m_8020_(0);
                    if (!slot0.m_41619_()) {
                        boolean added = player.m_150109_().m_36054_(slot0.m_41777_());
                        if (added) {
                            fishTrap.m_7407_(0, slot0.m_41613_());
                        } else {
                            FishTrapBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)slot0.m_41777_());
                            fishTrap.m_7407_(0, slot0.m_41613_());
                        }
                    }
                } else {
                    ItemStack output;
                    ItemStack heldItem = player.m_21120_(hand);
                    if (!heldItem.m_41619_() && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                        if (fishTrap.m_8020_(0).m_41619_()) {
                            ItemStack toInsert = heldItem.m_41777_();
                            toInsert.m_41764_(1);
                            fishTrap.m_6836_(0, toInsert);
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                        }
                    } else if (heldItem.m_41619_() && !(output = fishTrap.m_8020_(1)).m_41619_()) {
                        boolean added = player.m_150109_().m_36054_(output.m_41777_());
                        if (added) {
                            fishTrap.m_7407_(1, output.m_41613_());
                        } else {
                            FishTrapBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)output.m_41777_());
                            fishTrap.m_7407_(1, output.m_41613_());
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : FishTrapBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.FISH_TRAP.get()), (lvl, pos, blkState, blockEntity) -> blockEntity.tick());
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (((Boolean)state.m_61143_((Property)FULL)).booleanValue() && random.m_188501_() < 0.1f) {
            double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.5;
            double y = (double)pos.m_123342_() + 0.7 + random.m_188500_() * 0.3;
            double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123774_, x, y, z, 0.0, 0.02, 0.0);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_ && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            int particleCount = 10;
            double centerX = (double)pos.m_123341_() + 0.5;
            double centerZ = (double)pos.m_123343_() + 0.5;
            double centerY = (double)pos.m_123342_() + 0.1;
            double velocity = 0.05;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 / (double)particleCount * (double)i;
                double radius = 0.15;
                for (int j = 0; j < 3; ++j) {
                    double x = centerX + radius * Math.cos(angle);
                    double z = centerZ + radius * Math.sin(angle);
                    double y = centerY + (double)j * 0.1;
                    double velX = Math.cos(angle) * velocity;
                    double velZ = Math.sin(angle) * velocity;
                    double velY = 0.02 + (double)j * 0.01;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, velX, velY, velZ);
                    radius += 0.4;
                }
            }
        }
    }

    public void updateBlockState(Level level, BlockPos pos, boolean full, boolean hasBait) {
        BlockState newState;
        BlockState state = level.m_8055_(pos);
        if (state != (newState = (BlockState)((BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(full))).m_61124_((Property)HAS_BAIT, (Comparable)Boolean.valueOf(hasBait)))) {
            level.m_7731_(pos, newState, 3);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity fishTrap = (FishTrapBlockEntity)blockEntity;
            for (int i = 0; i < fishTrap.m_6643_(); ++i) {
                ItemStack stack = fishTrap.m_8020_(i);
                if (stack.m_41619_()) continue;
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
            level.m_46747_(pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

