/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.lilis_lucky_lures.core.block.FishTrapBlock;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrapBlockEntity;
import org.joml.Quaternionf;

public class FishTrapBlockEntityRenderer
implements BlockEntityRenderer<FishTrapBlockEntity> {
    private long lastRenderTime = 0L;
    private float rotationAngle = 0.0f;
    private float movementTime = 0.0f;

    private void updateMovement(FishTrapBlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastRenderTime) / 1000.0f;
        this.lastRenderTime = currentTime;
        this.rotationAngle += deltaTime * 40.0f;
        this.rotationAngle %= 360.0f;
        this.movementTime += deltaTime * 1.5f;
    }

    public void render(FishTrapBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ItemStack itemToRender;
        if (blockEntity.m_58904_() == null) {
            return;
        }
        BlockState state = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_());
        if (!(state.m_60734_() instanceof FishTrapBlock)) {
            return;
        }
        boolean isFull = (Boolean)state.m_61143_((Property)FishTrapBlock.FULL);
        boolean hasBait = (Boolean)state.m_61143_((Property)FishTrapBlock.HAS_BAIT);
        boolean isHanging = (Boolean)state.m_61143_((Property)FishTrapBlock.HANGING);
        ItemStack itemStack = isFull ? blockEntity.m_8020_(1) : (itemToRender = hasBait ? blockEntity.m_8020_(0) : ItemStack.f_41583_);
        if (!itemToRender.m_41619_()) {
            this.updateMovement(blockEntity);
            poseStack.m_85836_();
            float angle = (float)Math.toRadians(this.rotationAngle);
            float radius = 0.12f;
            float baseYOffset = isHanging ? 0.125f : 0.0f;
            float xOffset = (float)Math.sin(this.movementTime) * 0.12f;
            float zOffset = (float)Math.cos(this.movementTime) * 0.12f;
            float yWave = (float)Math.sin(this.movementTime * 1.5f) * 0.05f;
            float tiltAngleX = (float)Math.sin(this.movementTime * 1.2f) * 5.0f;
            float tiltAngleZ = (float)Math.cos(this.movementTime * 1.4f) * 5.0f;
            poseStack.m_85837_(0.5 + (double)xOffset, 0.1 + (double)baseYOffset + (double)yWave, 0.5 + (double)zOffset);
            poseStack.m_252781_(new Quaternionf().rotationY(angle));
            poseStack.m_252781_(new Quaternionf().rotationX((float)Math.toRadians(tiltAngleX)));
            poseStack.m_252781_(new Quaternionf().rotationZ((float)Math.toRadians(tiltAngleZ)));
            float scale = 0.85f;
            poseStack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91291_().m_269128_(itemToRender, ItemDisplayContext.GROUND, 0xF00000, combinedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }
}

