/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;

public class FloatingDebrisModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new LilisLuckyLuresIdentifier("floating_debris"), "main");
    private final ModelPart button;
    private final ModelPart planks;
    private final ModelPart barrel;
    private final float baseYButton;
    private final float baseYPlanks;
    private final float baseYBarrel;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition button = partdefinition.m_171599_("button", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        button.m_171599_("button_r1", CubeListBuilder.m_171558_().m_171514_(24, 7).m_171488_(-3.0f, 1.0f, -1.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)17.0f, (float)3.0f, (float)6.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition planks = partdefinition.m_171599_("planks", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        planks.m_171599_("planks_r1", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-6.0f, 3.0f, -1.0f, 7.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)12.0f, (float)1.0f, (float)-15.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition barrel = partdefinition.m_171599_("barrel", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        barrel.m_171599_("barrel_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-15.0f, -11.0f, -1.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)11.0f, (float)3.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public FloatingDebrisModel(ModelPart root) {
        this.button = root.m_171324_("button");
        this.planks = root.m_171324_("planks");
        this.barrel = root.m_171324_("barrel");
        this.baseYButton = this.button.f_104201_;
        this.baseYPlanks = this.planks.f_104201_;
        this.baseYBarrel = this.barrel.f_104201_;
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof FloatingDebrisEntity) {
            FloatingDebrisEntity debrisEntity = (FloatingDebrisEntity)((Object)entity);
            float timeFactor = ageInTicks * 0.1f;
            float buttonOscillation = (float)Math.sin(timeFactor + 0.5f) * 0.25f;
            float planksOscillation = (float)Math.sin(timeFactor + 0.3f) * 0.35f;
            float barrelOscillation = (float)Math.sin(timeFactor + 0.7f) * 0.3f;
            float buttonRotation = (float)Math.cos(timeFactor * 0.8f) * 0.05f;
            float planksRotation = (float)Math.sin(timeFactor * 0.7f) * 0.07f;
            float barrelRotation = (float)Math.cos(timeFactor * 0.6f) * 0.06f;
            float sideDriftX = (float)Math.sin(timeFactor * 0.4f) * 0.2f;
            float sideDriftZ = (float)Math.cos(timeFactor * 0.4f) * 0.2f;
            this.button.m_104227_(sideDriftX, this.baseYButton + buttonOscillation, sideDriftZ);
            this.planks.m_104227_(-sideDriftX, this.baseYPlanks + planksOscillation, -sideDriftZ);
            this.barrel.m_104227_(sideDriftZ, this.baseYBarrel + barrelOscillation, -sideDriftX);
            this.button.f_104203_ = buttonRotation;
            this.planks.f_104205_ = planksRotation;
            this.barrel.f_104203_ = barrelRotation;
            if (debrisEntity.getHurtTime() > 0) {
                int hurtTime = debrisEntity.getHurtTime();
                int maxHurtTime = 10;
                float hurtProgress = 1.0f - (float)hurtTime / (float)maxHurtTime;
                float offset = (float)Math.sin((double)(hurtProgress * 2.0f) * Math.PI) * 0.5f;
                float explosionOffsetX = (float)Math.sin((double)hurtProgress * Math.PI * 2.0) * 0.5f;
                float explosionOffsetZ = (float)Math.cos((double)hurtProgress * Math.PI * 2.0) * 0.5f;
                this.button.m_104227_(explosionOffsetX, this.baseYButton + offset, explosionOffsetZ);
                this.planks.m_104227_(-explosionOffsetX, this.baseYPlanks + offset, -explosionOffsetZ);
                this.barrel.m_104227_(explosionOffsetZ, this.baseYBarrel + offset, explosionOffsetX);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.button.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.planks.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.barrel.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

