/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.client.entity.PellsEntity;
import com.berksire.furniture.client.model.PellsModel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PellsRenderer
extends MobRenderer<PellsEntity, PellsModel<PellsEntity>> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("furniture", "textures/entity/pells.png");
    private static final DecimalFormat FORMAT = new DecimalFormat("###.##", new DecimalFormatSymbols(Locale.GERMAN));

    public PellsRenderer(EntityRendererProvider.Context context) {
        super(context, new PellsModel(PellsModel.createBodyLayer().m_171564_()), 0.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(PellsEntity entity) {
        return TEXTURE;
    }

    public void render(PellsEntity entityIn, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        float lastDamage = entityIn.getLastDamage();
        if (lastDamage > 0.0f) {
            Color color = this.getColorByDamage(lastDamage);
            this.renderText(entityIn, FORMAT.format(lastDamage), stack, bufferIn, packedLightIn, color);
        }
    }

    private Color getColorByDamage(float damage) {
        if (damage >= 0.0f && damage <= 2.0f) {
            return Color.GREEN;
        }
        if (damage >= 3.0f && damage <= 6.0f) {
            return Color.WHITE;
        }
        if (damage >= 7.0f && damage <= 12.0f) {
            return Color.YELLOW;
        }
        if (damage >= 13.0f && damage <= 19.0f) {
            return Color.ORANGE;
        }
        return Color.RED;
    }

    protected void renderText(PellsEntity entityIn, String text, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Color textColor) {
        if (entityIn.f_20916_ > 0) {
            float partialTicks = Minecraft.m_91087_().m_91296_();
            MutableComponent component = Component.m_237113_((String)text);
            entityIn.lastDamageOffsetPrev = entityIn.lastDamageOffset = Mth.m_14179_((float)partialTicks, (float)entityIn.lastDamageOffsetPrev, (float)((float)Math.abs(Math.sin((float)entityIn.f_20916_ / 4.0f))));
            float alpha = entityIn.lastDamageOffset;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, (double)(entityIn.m_20206_() + entityIn.lastDamageOffset), 0.0);
            matrixStackIn.m_252781_(this.f_114476_.m_253208_());
            matrixStackIn.m_85841_(-entityIn.lastDamageOffset / 20.0f, -entityIn.lastDamageOffset / 20.0f, entityIn.lastDamageOffset / 20.0f);
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
            Font font = this.m_114481_();
            Color color = new Color((float)textColor.getRed() / 255.0f, (float)textColor.getGreen() / 255.0f, (float)textColor.getBlue() / 255.0f, alpha);
            font.m_272077_((Component)component, (float)(-font.m_92852_((FormattedText)component) / 2) * entityIn.lastDamageOffset, entityIn.lastDamageOffset, color.getRGB(), false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, packedLightIn);
            matrixStackIn.m_85849_();
        }
    }
}

