/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.FishTankBlock;
import com.berksire.furniture.block.entity.FishTankBlockEntity;
import com.berksire.furniture.client.entity.FakeFishTankEntity;
import com.berksire.furniture.client.model.FishTankModel;
import com.berksire.furniture.client.render.FluidRenderer;
import com.berksire.furniture.registry.ObjectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.architectury.fluid.FluidStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class FishTankRenderer
extends EntityRenderer<FakeFishTankEntity> {
    private final FishTankModel model;
    private static final ResourceLocation NORMAL_TEXTURE = new ResourceLocation("furniture", "textures/entity/copper_fish_tank.png");
    private static final ResourceLocation IRON_TEXTURE = new ResourceLocation("furniture", "textures/entity/iron_fish_tank.png");

    public FishTankRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new FishTankModel(context.m_174023_(FishTankModel.LAYER_LOCATION));
    }

    private static boolean assertNonNullOrPop(Object nullable, PoseStack stack) {
        if (nullable == null) {
            stack.m_85849_();
            return true;
        }
        return false;
    }

    public void render(FakeFishTankEntity entity, float f, float g, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        boolean isFoot;
        poseStack.m_85836_();
        FishTankBlockEntity blockEntity = entity.getNearestTankEntity().orElse(null);
        if (FishTankRenderer.assertNonNullOrPop((Object)blockEntity, poseStack)) {
            return;
        }
        assert (blockEntity != null);
        boolean bl = isFoot = blockEntity.m_58900_().m_61143_(FishTankBlock.PART) == BedPart.FOOT;
        if (!isFoot) {
            poseStack.m_85849_();
            return;
        }
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)FishTankBlock.FACING);
        float rotation = -direction.m_122435_();
        Quaternionf theGreatRotator = new Quaternionf().rotateY((float)Math.toRadians(rotation - 90.0f));
        poseStack.m_252781_(theGreatRotator);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        ResourceLocation texture = blockEntity.m_58900_().m_60734_() == ObjectRegistry.IRON_FISH_TANK.get() ? IRON_TEXTURE : NORMAL_TEXTURE;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(texture));
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (FishTankRenderer.assertNonNullOrPop(world, poseStack)) {
            return;
        }
        assert (world != null);
        float renderTick = (float)(world.m_46467_() % 24000L) + Minecraft.m_91087_().m_91296_();
        this.model.setupAnim(entity, f, g, renderTick, 0.0f, 0.0f);
        if (((Boolean)blockEntity.m_58900_().m_61143_((Property)FishTankBlock.HAS_COD)).booleanValue()) {
            this.model.cod_1.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.cod_2.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.cod_3.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.cod_4.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (((Boolean)blockEntity.m_58900_().m_61143_((Property)FishTankBlock.HAS_PUFFERFISH)).booleanValue()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, -0.6, 0.0);
            this.model.pufferfish_1.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.9, -0.8, 0.1);
            this.model.pufferfish_2.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        if (((Boolean)blockEntity.m_58900_().m_61143_((Property)FishTankBlock.HAS_SALMON)).booleanValue()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 0.05);
            this.model.salmon_1.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            this.model.salmon_2.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.model.tank.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model.decoration.m_104306_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(theGreatRotator);
        poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(90.0)));
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        FluidRenderer.renderFluidBox(FluidStack.create((Fluid)Fluids.f_76193_, (long)100L), 0.0703125f, 0.125f, 0.0703125f, 0.9296875f, 0.85f, 1.9296875f, bufferSource, poseStack, combinedLight, false);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(FakeFishTankEntity entity) {
        return NORMAL_TEXTURE;
    }
}

