/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.CofferBlock;
import com.berksire.furniture.block.entity.CofferBlockEntity;
import com.berksire.furniture.util.FurnitureIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class CofferRenderer
implements BlockEntityRenderer<CofferBlockEntity> {
    private static final ResourceLocation TEXTURE = new FurnitureIdentifier("textures/entity/coffer.png");
    private final ModelPart coffer;
    private final ModelPart top;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new FurnitureIdentifier("coffer"), "main");

    public CofferRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(LAYER_LOCATION);
        this.coffer = modelPart.m_171324_("coffer");
        ModelPart bottom = this.coffer.m_171324_("bottom");
        this.top = this.coffer.m_171324_("top");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition coffer = partdefinition.m_171599_("coffer", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bottom = coffer.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-13.0f, -5.0f, -1.0f, 14.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)0.0f, (float)-4.0f));
        PartDefinition top = coffer.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-13.0f, -3.0f, -1.0f, 14.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -1.0f, 9.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-5.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(CofferBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float lidAngle = blockEntity.m_6683_(partialTicks);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - (float)Math.pow(lidAngle, 1.0);
        float bounce = (float)Math.sin((double)lidAngle * Math.PI);
        this.top.f_104203_ = lidAngle * 1.5707964f + bounce;
        poseStack.m_85836_();
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)CofferBlock.FACING);
        switch (facing) {
            case NORTH: {
                poseStack.m_85837_(1.0, 1.0, 0.0);
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.0, 1.0, 1.0);
                break;
            }
            case EAST: {
                poseStack.m_85837_(1.0, 1.0, 1.0);
                break;
            }
            case WEST: {
                poseStack.m_85837_(0.0, 1.0, 0.0);
            }
        }
        poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-facing.m_122435_() + 180.0f)));
        poseStack.m_252781_(new Quaternionf().rotateX((float)Math.toRadians(180.0)));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.coffer.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }
}

