/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SteamVentBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty PARTICLES_ENABLED = BooleanProperty.m_61465_((String)"particles_enabled");
    private static final Map<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>>();
    private static final Map<FurnitureUtil.VerticalConnectingType, VoxelShape> SHAPES = new EnumMap<FurnitureUtil.VerticalConnectingType, VoxelShape>(FurnitureUtil.VerticalConnectingType.class);

    public SteamVentBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PARTICLES_ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED, PARTICLES_ENABLED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = this.m_49966_();
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        blockState = (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_7494_()), world.m_8055_(clickedPos.m_7495_()))));
        return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.m_8055_(pos.m_7494_()), world.m_8055_(pos.m_7495_()));
        if (state.m_61143_(TYPE) != type) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        world.m_7731_(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState state, BlockState above, BlockState below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.m_60734_() == state.m_60734_();
        boolean bl = shapeBelowSame = below.m_60734_() == state.m_60734_();
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.m_61143_(TYPE));
        return SHAPES.get((Object)type);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            boolean particlesEnabled = (Boolean)state.m_61143_((Property)PARTICLES_ENABLED);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)PARTICLES_ENABLED, (Comparable)Boolean.valueOf(!particlesEnabled)), 3);
            String messageKey = particlesEnabled ? "tooltip.furniture.vent_disabled" : "tooltip.furniture.vent_enabled";
            player.m_5661_((Component)Component.m_237115_((String)messageKey), true);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)PARTICLES_ENABLED)).booleanValue() && (state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.NONE || state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.BOTTOM)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_() - 1;
            double z = (double)pos.m_123343_() + 0.5;
            double vx = 0.0;
            double vy = 0.02 + random.m_188500_() * 0.02;
            double vz = 0.0;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, vx, vy, vz);
        }
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.NONE, SteamVentBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.MIDDLE, SteamVentBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.TOP, SteamVentBlock::makeTopShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.BOTTOM, SteamVentBlock::makeBottomShape);
        for (Map.Entry<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> entry : SHAPES_SUPPLIERS.entrySet()) {
            SHAPES.put(entry.getKey(), entry.getValue().get());
        }
    }
}

