/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.entity.GramophoneBlockEntity;
import com.berksire.furniture.registry.EntityTypeRegistry;
import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GramophoneBlock
extends BaseEntityBlock {
    public static final BooleanProperty HAS_RECORD = BlockStateProperties.f_61439_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty REPEAT = BooleanProperty.m_61465_((String)"repeat");
    private static final VoxelShape SHAPE_LOWER = GramophoneBlock.makeLowerShape();
    private static final VoxelShape SHAPE_UPPER = GramophoneBlock.makeUpperShape();
    public static final Map<Direction, VoxelShape> SHAPE_LOWER_MAP = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, SHAPE_LOWER));
        }
    });
    public static final Map<Direction, VoxelShape> SHAPE_UPPER_MAP = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, SHAPE_UPPER));
        }
    });

    public GramophoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HAS_RECORD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)REPEAT, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape makeLowerShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.75, (double)0.3125, (double)0.875, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.875, (double)0.375, (double)0.75, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.5, (double)0.8125, (double)0.5625, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeUpperShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.3125, (double)0.875, (double)0.5, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.375, (double)0.75, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.6875, (double)0.625, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos abovePos = blockPos.m_7494_();
        level.m_7731_(abovePos, (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)))).m_61124_((Property)HAS_RECORD, (Comparable)((Boolean)blockState.m_61143_((Property)HAS_RECORD)))).m_61124_((Property)REPEAT, (Comparable)((Boolean)blockState.m_61143_((Property)REPEAT))), 3);
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            DoubleBlockHalf half;
            BlockPos otherPos;
            BlockState otherState;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof GramophoneBlockEntity) {
                GramophoneBlockEntity gramophoneBlockEntity = (GramophoneBlockEntity)blockEntity;
                gramophoneBlockEntity.stopPlayingOnRemove();
                gramophoneBlockEntity.popOutRecord();
                level.m_46747_(blockPos);
            }
            if ((otherState = level.m_8055_(otherPos = (half = (DoubleBlockHalf)blockState.m_61143_(HALF)) == DoubleBlockHalf.LOWER ? blockPos.m_7494_() : blockPos.m_7495_())).m_60713_((Block)this) && otherState.m_61143_(HALF) != half) {
                level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
                level.m_46796_(2001, otherPos, Block.m_49956_((BlockState)otherState));
            }
        }
        super.m_6810_(blockState, level, blockPos, newState, isMoving);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(state, world, pos);
        }
        BlockState belowState = world.m_8055_(pos.m_7495_());
        return belowState.m_60713_((Block)this) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        return pos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(pos.m_7494_()).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_RECORD, FACING, HALF, REPEAT});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? SHAPE_UPPER_MAP.get(state.m_61143_((Property)FACING)) : SHAPE_LOWER_MAP.get(state.m_61143_((Property)FACING));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return GramophoneBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.GRAMOPHONE_BLOCK_ENTITY.get()), GramophoneBlockEntity::playRecordTick);
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GramophoneBlockEntity(blockPos, blockState);
    }

    public boolean m_7899_(BlockState blockState) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        GramophoneBlockEntity discPlayerBlockEntity;
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity instanceof GramophoneBlockEntity && (discPlayerBlockEntity = (GramophoneBlockEntity)blockEntity).isRecordPlaying()) {
            return 15;
        }
        return 0;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        GramophoneBlockEntity discPlayerBlockEntity;
        Item item;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof GramophoneBlockEntity && (item = (discPlayerBlockEntity = (GramophoneBlockEntity)blockEntity).getFirstItem().m_41720_()) instanceof RecordItem) {
            RecordItem recordItem = (RecordItem)item;
            return recordItem.m_43049_();
        }
        return 0;
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof GramophoneBlockEntity) {
            GramophoneBlockEntity discPlayerBlockEntity = (GramophoneBlockEntity)blockEntity;
            ItemStack itemStack = player.m_21120_(interactionHand);
            if (player.m_6144_()) {
                if (((Boolean)blockState.m_61143_((Property)HAS_RECORD)).booleanValue()) {
                    discPlayerBlockEntity.popOutRecord();
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else {
                if (itemStack.m_41619_()) {
                    boolean repeat = discPlayerBlockEntity.isRepeat();
                    discPlayerBlockEntity.setRepeat(!repeat);
                    player.m_5661_((Component)Component.m_237110_((String)"tooltip.furniture.repeat_mode", (Object[])new Object[]{Component.m_237115_((String)(!repeat ? "tooltip.furniture.on" : "tooltip.furniture.off"))}), true);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (itemStack.m_41720_() instanceof RecordItem && !((Boolean)blockState.m_61143_((Property)HAS_RECORD)).booleanValue()) {
                    discPlayerBlockEntity.setRecord(itemStack.m_41777_());
                    itemStack.m_41774_(1);
                    level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)HAS_RECORD, (Comparable)Boolean.valueOf(true)), 3);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

