/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.entity.FishTankBlockEntity;
import com.berksire.furniture.registry.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishTankBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final EnumProperty<BedPart> PART = EnumProperty.m_61587_((String)"part", BedPart.class);
    public static final BooleanProperty HAS_COD = BooleanProperty.m_61465_((String)"has_cod");
    public static final BooleanProperty HAS_PUFFERFISH = BooleanProperty.m_61465_((String)"has_pufferfish");
    public static final BooleanProperty HAS_SALMON = BooleanProperty.m_61465_((String)"has_salmon");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public FishTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)HAS_COD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_PUFFERFISH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_SALMON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, HAS_COD, HAS_PUFFERFISH, HAS_SALMON, FACING});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (state.m_61143_(PART) == BedPart.FOOT) {
            BlockPos headPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
            world.m_7731_(headPos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BedPart part = (BedPart)state.m_61143_(PART);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        VoxelShape footShape = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.125, (double)0.0, (double)0.9375, (double)0.875, (double)0.9375));
        footShape = Shapes.m_83110_((VoxelShape)footShape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        VoxelShape headShape = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.875, (double)1.0));
        headShape = Shapes.m_83110_((VoxelShape)headShape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        VoxelShape selectedShape = part == BedPart.FOOT ? footShape : headShape;
        return FishTankBlock.rotate(selectedShape, Direction.NORTH, facing);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing;
        BlockPos pos;
        BlockPos headPos;
        Level world = context.m_43725_();
        if (world.m_8055_(headPos = (pos = context.m_8083_()).m_121945_(facing = context.m_8125_().m_122424_())).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)BedPart.FOOT);
        }
        return null;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, SoundEvents.f_12540_, SoundSource.BLOCKS, 0.05f, 0.95f, false);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FishTankBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return FishTankBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.FISH_TANK_BLOCK_ENTITY.get()), (level1, pos, state, blockEntity) -> FishTankBlockEntity.tick(level1, pos, blockEntity));
    }

    private static VoxelShape rotate(VoxelShape shape, Direction originalDir, Direction newDir) {
        if (originalDir != newDir) {
            VoxelShape[] newShape = new VoxelShape[]{Shapes.m_83040_()};
            shape.m_83286_((x, y, z, a, b, c) -> {
                double i = 1.0 - c;
                double j = 1.0 - z;
                newShape[0] = Shapes.m_83110_((VoxelShape)newShape[0], (VoxelShape)Shapes.m_83048_((double)Math.min(i, j), (double)y, (double)x, (double)Math.max(i, j), (double)b, (double)a));
            });
            return FishTankBlock.rotate(newShape[0], originalDir.m_122427_(), newDir);
        }
        return shape;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        FishTankBlockEntity blockEntity = (FishTankBlockEntity)world.m_7702_(pos);
        if (blockEntity != null) {
            boolean hasModified = false;
            if (itemStack.m_41720_() == Items.f_42457_ && !blockEntity.hasSalmon()) {
                blockEntity.setHasSalmon(true);
                hasModified = true;
            } else if (itemStack.m_41720_() == Items.f_42456_ && !blockEntity.hasPufferfish()) {
                blockEntity.setHasPufferfish(true);
                hasModified = true;
            } else if (itemStack.m_41720_() == Items.f_42458_ && !blockEntity.hasCod()) {
                blockEntity.setHasCod(true);
                hasModified = true;
            }
            if (hasModified) {
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)HAS_SALMON, (Comparable)Boolean.valueOf(blockEntity.hasSalmon()))).m_61124_((Property)HAS_PUFFERFISH, (Comparable)Boolean.valueOf(blockEntity.hasPufferfish()))).m_61124_((Property)HAS_COD, (Comparable)Boolean.valueOf(blockEntity.hasCod())), 3);
                BlockPos otherPartPos = state.m_61143_(PART) == BedPart.FOOT ? pos.m_121945_((Direction)state.m_61143_((Property)FACING)) : pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
                BlockState otherPartState = world.m_8055_(otherPartPos);
                if (otherPartState.m_60734_() == this) {
                    world.m_7731_(otherPartPos, (BlockState)((BlockState)((BlockState)otherPartState.m_61124_((Property)HAS_SALMON, (Comparable)Boolean.valueOf(blockEntity.hasSalmon()))).m_61124_((Property)HAS_PUFFERFISH, (Comparable)Boolean.valueOf(blockEntity.hasPufferfish()))).m_61124_((Property)HAS_COD, (Comparable)Boolean.valueOf(blockEntity.hasCod())), 3);
                }
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        FishTankBlockEntity blockEntity;
        super.m_5707_(world, pos, state, player);
        BlockPos otherPartPos = state.m_61143_(PART) == BedPart.FOOT ? pos.m_121945_((Direction)state.m_61143_((Property)FACING)) : pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        BlockState otherPartState = world.m_8055_(otherPartPos);
        if (otherPartState.m_60734_() == this && otherPartState.m_61143_(PART) != state.m_61143_(PART)) {
            world.m_46961_(otherPartPos, false);
        }
        if ((blockEntity = (FishTankBlockEntity)world.m_7702_(pos)) != null) {
            if (blockEntity.hasCod()) {
                Cod cod = new Cod(EntityType.f_20556_, world);
                cod.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)cod);
            }
            if (blockEntity.hasSalmon()) {
                Salmon salmon = new Salmon(EntityType.f_20519_, world);
                salmon.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)salmon);
            }
            if (blockEntity.hasPufferfish()) {
                Pufferfish pufferfish = new Pufferfish(EntityType.f_20516_, world);
                pufferfish.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)pufferfish);
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

