/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplorersBoxBlock
extends CartographyTableBlock {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.furniture.explorers_box");
    public static final DirectionProperty FACING;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    public static final Map<Direction, VoxelShape> SHAPE;

    public ExplorersBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public MenuProvider m_7246_(BlockState blockState, Level level, BlockPos blockPos) {
        return new SimpleMenuProvider((i, inventory, player) -> new CartographyTableMenu(i, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)blockPos)), CONTAINER_TITLE);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.625, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.25, (double)0.0625, (double)0.625, (double)0.5, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.625, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
            }
        });
        FACING = HorizontalDirectionalBlock.f_54117_;
    }
}

