/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE;
    public static final BooleanProperty OPEN;
    public static final BooleanProperty POWERED;
    public static final BooleanProperty WATERLOGGED;
    private final DyeColor color;
    public static final Map<Direction, VoxelShape> SHAPE_TOP_OR_SINGLE;
    public static final Map<Direction, VoxelShape> SHAPE_OTHER;

    public CurtainBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos;
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level world = context.m_43725_();
        if (world.m_276867_(clickedPos = context.m_8083_())) {
            blockState = (BlockState)((BlockState)blockState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        blockState = (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_7494_()), world.m_8055_(clickedPos.m_7495_()))));
        return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        boolean powered = world.m_276867_(pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            if ((Boolean)state.m_61143_((Property)OPEN) != powered) {
                state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
                world.m_5594_(null, pos, CurtainBlock.Curtainsound(powered), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (((Boolean)(state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
            }
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.m_8055_(pos.m_7494_()), world.m_8055_(pos.m_7495_()));
        if (state.m_61143_(TYPE) != type) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        world.m_7731_(pos, state, 3);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.toggleCurtain(state, level, pos, player);
    }

    public InteractionResult toggleCurtain(BlockState state, Level level, BlockPos pos, Player player) {
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 3);
        if (player == null || !player.m_6047_()) {
            this.toggleCurtain(state, level, pos, (Boolean)state.m_61143_((Property)OPEN));
        }
        level.m_5594_(null, pos, CurtainBlock.Curtainsound((Boolean)state.m_61143_((Property)OPEN)), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void toggleCurtain(BlockState state, Level level, BlockPos pos, boolean open) {
        int i;
        BlockState updateState = state;
        BlockPos updatePos = pos;
        if (state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.MIDDLE || state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.BOTTOM) {
            BlockState above;
            int heightUp = level.m_6042_().f_156648_() - updatePos.m_123342_();
            for (i = 0; i < heightUp && (above = level.m_8055_(updatePos.m_7494_())).m_60713_(state.m_60734_()) && above.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && (Boolean)above.m_61143_((Property)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.m_7494_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.MIDDLE || state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.TOP) {
            BlockState below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.m_6042_().f_156647_() - updatePos.m_123342_();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.m_8055_(updatePos.m_7495_())).m_60713_(state.m_60734_()) && below.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && (Boolean)below.m_61143_((Property)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.m_7495_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static SoundEvent Curtainsound(boolean open) {
        if (open) {
            return SoundEvents.f_12640_;
        }
        return SoundEvents.f_12642_;
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState state, BlockState above, BlockState below) {
        boolean shape_below_same;
        boolean shape_above_same = above.m_60734_() == state.m_60734_() && above.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && above.m_61143_((Property)OPEN) == state.m_61143_((Property)OPEN);
        boolean bl = shape_below_same = below.m_60734_() == state.m_60734_() && below.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && below.m_61143_((Property)OPEN) == state.m_61143_((Property)OPEN);
        if (shape_above_same && !shape_below_same) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        if (shape_above_same) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, OPEN, POWERED, WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    private static VoxelShape makeTopOrSingleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeOtherShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.m_61143_(TYPE));
        if (type == FurnitureUtil.VerticalConnectingType.TOP || type == FurnitureUtil.VerticalConnectingType.NONE) {
            return SHAPE_TOP_OR_SINGLE.get(direction);
        }
        return SHAPE_OTHER.get(direction);
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean m_222958_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    static {
        SHAPE_TOP_OR_SINGLE = (Map)Util.m_137469_(new HashMap(), map -> {
            Supplier<VoxelShape> voxelShapeSupplier = CurtainBlock::makeTopOrSingleShape;
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
            }
        });
        SHAPE_OTHER = (Map)Util.m_137469_(new HashMap(), map -> {
            Supplier<VoxelShape> voxelShapeSupplier = CurtainBlock::makeOtherShape;
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
            }
        });
        FACING = BlockStateProperties.f_61374_;
        TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
        OPEN = BlockStateProperties.f_61446_;
        POWERED = BlockStateProperties.f_61448_;
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

