/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.entity.ChairEntity;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>> CHAIRS = new HashMap<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>>();
    private static final String BLOCK_POS_KEY = "block_pos";
    private static final String BLOCK_POSES_KEY = "block_poses";
    public static final EnumProperty<LineConnectingType> LINE_CONNECTING_TYPE = EnumProperty.m_61587_((String)"type", LineConnectingType.class);

    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = GeneralUtil.registerWithoutItem(registerB, registrarB, name, block);
        GeneralUtil.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static boolean isFullAndSolid(LevelReader levelReader, BlockPos blockPos) {
        return GeneralUtil.isFaceFull(levelReader, blockPos) && GeneralUtil.isSolid(levelReader, blockPos);
    }

    public static boolean isFaceFull(LevelReader levelReader, BlockPos blockPos) {
        BlockPos belowPos = blockPos.m_7495_();
        return Block.m_49918_((VoxelShape)levelReader.m_8055_(belowPos).m_60808_((BlockGetter)levelReader, belowPos), (Direction)Direction.UP);
    }

    public static boolean isSolid(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.m_8055_(blockPos.m_7495_()).m_280296_();
    }

    public static boolean matchesRecipe(Container inventory, NonNullList<Ingredient> recipe, int startIndex, int endIndex) {
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            inputStacks.add(stack.m_41777_());
        }
        if (inputStacks.size() != recipe.size()) {
            return false;
        }
        ArrayList<Ingredient> unmatched = new ArrayList<Ingredient>((Collection<Ingredient>)recipe);
        for (ItemStack input : inputStacks) {
            boolean matched = false;
            Iterator iter = unmatched.iterator();
            while (iter.hasNext()) {
                if (!((Ingredient)iter.next()).test(input)) continue;
                iter.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return unmatched.isEmpty();
    }

    public static NonNullList<Ingredient> deserializeIngredients(JsonArray json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static void spawnSlice(Level level, ItemStack stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        entity.m_20334_(xMotion, yMotion, zMotion);
        level.m_7967_((Entity)entity);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new ChunkPos(pos));
    }

    public static ItemStack convertStackAfterFinishUsing(LivingEntity entity, ItemStack used, Item returnItem, Item usedItem) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, used);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)usedItem));
        }
        if (used.m_41619_()) {
            return new ItemStack((ItemLike)returnItem);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!((Player)entity).m_150110_().f_35937_) {
                ItemStack itemStack2 = new ItemStack((ItemLike)returnItem);
                if (!player.m_150109_().m_36054_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
            }
        }
        return used;
    }

    public static InteractionResult onUse(Level world, Player player, InteractionHand hand, BlockHitResult hit, double extraHeight) {
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (GeneralUtil.isPlayerSitting(player)) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockPos hitPos = hit.m_82425_();
        if (!GeneralUtil.isOccupied(world, hitPos) && player.m_21120_(hand).m_41619_()) {
            ChairEntity chair = (ChairEntity)((EntityType)EntityTypeRegistry.CHAIR.get()).m_20615_(world);
            assert (chair != null);
            chair.m_7678_((double)hitPos.m_123341_() + 0.5, (double)hitPos.m_123342_() + 0.25 + extraHeight, (double)hitPos.m_123343_() + 0.5, 0.0f, 0.0f);
            if (GeneralUtil.addChairEntity(world, hitPos, chair, player.m_20183_())) {
                world.m_7967_((Entity)chair);
                player.m_20329_((Entity)chair);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, ChairEntity chairEntity) {
        ResourceLocation id;
        if (!player.m_9236_().m_5776_() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(player.m_9236_()))) {
            Map<BlockPos, Pair<ChairEntity, BlockPos>> chairsInDimension = CHAIRS.get(id);
            for (Pair<ChairEntity, BlockPos> chairPair : chairsInDimension.values()) {
                if (chairPair.getFirst() != chairEntity) continue;
                return (BlockPos)chairPair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(Level world, BlockPos pos) {
        ResourceLocation id = GeneralUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level world) {
        return world.m_220362_().m_135782_();
    }

    public static void onStateReplaced(Level world, BlockPos pos) {
        ChairEntity entity;
        if (!world.f_46443_ && (entity = GeneralUtil.getChairEntity(world, pos)) != null) {
            GeneralUtil.removeChairEntity(world, pos);
            entity.m_20153_();
        }
    }

    public static boolean addChairEntity(Level world, BlockPos blockPos, ChairEntity entity, BlockPos playerPos) {
        if (!world.f_46443_) {
            ResourceLocation id = GeneralUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.f_46443_ && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
        }
    }

    public static ChairEntity getChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.m_5776_() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static boolean isDamageType(DamageSource source, List<ResourceKey<DamageType>> damageTypes) {
        ResourceKey<DamageType> damageKey;
        Iterator<ResourceKey<DamageType>> iterator = damageTypes.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!source.m_276093_(damageKey = iterator.next()));
        return true;
    }

    public static boolean isFire(DamageSource source) {
        return GeneralUtil.isDamageType(source, List.of(DamageTypes.f_268468_, DamageTypes.f_268631_, DamageTypes.f_268684_, DamageTypes.f_268428_, DamageTypes.f_268556_));
    }

    public static boolean isIndexInRange(int index, int startInclusive, int endInclusive) {
        return index >= startInclusive && index <= endInclusive;
    }

    public static FriendlyByteBuf create() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static void popResourceFromFace(Level level, BlockPos blockPos, Direction side, ItemStack itemStack) {
        BlockState blockState = level.m_8055_(blockPos);
        double itemWidth = EntityType.f_20461_.m_20678_();
        double itemHeight = EntityType.f_20461_.m_20679_();
        VoxelShape shape = blockState.m_60812_((BlockGetter)level, blockPos);
        double posX = (double)blockPos.m_123341_() + 0.5;
        double posY = (double)blockPos.m_123342_() + 0.5;
        double posZ = (double)blockPos.m_123343_() + 0.5;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        switch (side) {
            case DOWN: {
                posY = (double)blockPos.m_123342_() - shape.m_83288_(Direction.Axis.Y);
                offsetY = -itemHeight * 2.0;
                break;
            }
            case UP: {
                posY = (double)blockPos.m_123342_() + shape.m_83297_(Direction.Axis.Y);
                break;
            }
            case NORTH: {
                posZ = (double)blockPos.m_123343_() + shape.m_83288_(Direction.Axis.Z);
                offsetZ = -itemWidth;
                break;
            }
            case SOUTH: {
                posZ = (double)blockPos.m_123343_() + shape.m_83297_(Direction.Axis.Z);
                offsetZ = itemWidth;
                break;
            }
            case WEST: {
                posX = (double)blockPos.m_123341_() + shape.m_83288_(Direction.Axis.X);
                offsetX = -itemWidth;
                break;
            }
            case EAST: {
                posX = (double)blockPos.m_123341_() + shape.m_83297_(Direction.Axis.X);
                offsetX = itemWidth;
            }
        }
        int i = side.m_122429_();
        int j = side.m_122430_();
        int k = side.m_122431_();
        double deltaX = i == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.1, (double)0.1) : (double)i * 0.1;
        double deltaY = j == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)0.0, (double)0.1) : (double)j * 0.1 + 0.1;
        double deltaZ = k == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.1, (double)0.1) : (double)k * 0.1;
        GeneralUtil.popResource(level, new ItemEntity(level, posX + offsetX, posY + offsetY, posZ + offsetZ, itemStack, deltaX, deltaY, deltaZ), itemStack);
    }

    private static void popResource(Level level, ItemEntity itemEntity, ItemStack itemStack) {
        if (!level.f_46443_ && !itemStack.m_41619_() && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static void putBlockPos(CompoundTag compoundTag, BlockPos blockPos) {
        if (blockPos != null) {
            int[] positions = new int[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()};
            compoundTag.m_128385_(BLOCK_POS_KEY, positions);
        }
    }

    public static void putBlockPoses(CompoundTag compoundTag, Collection<BlockPos> blockPoses) {
        if (blockPoses != null && !blockPoses.isEmpty()) {
            int[] positions = new int[blockPoses.size() * 3];
            int pos = 0;
            for (BlockPos blockPos : blockPoses) {
                positions[pos * 3] = blockPos.m_123341_();
                positions[pos * 3 + 1] = blockPos.m_123342_();
                positions[pos * 3 + 2] = blockPos.m_123343_();
                ++pos;
            }
            compoundTag.m_128385_(BLOCK_POSES_KEY, positions);
        }
    }

    @Nullable
    public static BlockPos readBlockPos(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(BLOCK_POS_KEY)) {
            return null;
        }
        int[] positions = compoundTag.m_128465_(BLOCK_POS_KEY);
        return new BlockPos(positions[0], positions[1], positions[2]);
    }

    public static Set<BlockPos> readBlockPoses(CompoundTag compoundTag) {
        HashSet<BlockPos> blockSet = new HashSet<BlockPos>();
        if (compoundTag.m_128441_(BLOCK_POSES_KEY)) {
            int[] positions = compoundTag.m_128465_(BLOCK_POSES_KEY);
            for (int pos = 0; pos < positions.length / 3; ++pos) {
                blockSet.add(new BlockPos(positions[pos * 3], positions[pos * 3 + 1], positions[pos * 3 + 2]));
            }
        }
        return blockSet;
    }

    public static Optional<Tuple<Float, Float>> getRelativeHitCoordinatesForBlockFace(BlockHitResult blockHitResult, Direction direction, Direction[] unAllowedDirections) {
        Direction direction2 = blockHitResult.m_82434_();
        if (Arrays.asList(unAllowedDirections).contains(direction2)) {
            return Optional.empty();
        }
        if (direction != direction2 && direction2 != Direction.UP && direction2 != Direction.DOWN) {
            return Optional.empty();
        }
        BlockPos blockPos = blockHitResult.m_82425_().m_121945_(direction2);
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        float d = (float)vec3.m_7096_();
        float f = (float)vec3.m_7094_();
        float y = (float)vec3.m_7098_();
        if (direction2 == Direction.UP || direction2 == Direction.DOWN) {
            direction2 = direction;
        }
        return switch (direction2) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Optional.of(new Tuple((Object)Float.valueOf((float)(1.0 - (double)d)), (Object)Float.valueOf(y)));
            case Direction.SOUTH -> Optional.of(new Tuple((Object)Float.valueOf(d), (Object)Float.valueOf(y)));
            case Direction.WEST -> Optional.of(new Tuple((Object)Float.valueOf(f), (Object)Float.valueOf(y)));
            case Direction.EAST -> Optional.of(new Tuple((Object)Float.valueOf((float)(1.0 - (double)f)), (Object)Float.valueOf(y)));
            case Direction.DOWN, Direction.UP -> Optional.empty();
        };
    }

    public static enum LineConnectingType implements StringRepresentable
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }

    public static class FoodComponent
    extends FoodProperties {
        public FoodComponent(List<Pair<MobEffectInstance, Float>> statusEffects) {
            super(1, 0.0f, false, true, false, statusEffects);
        }
    }
}

