/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.candlelight.client.model.CookingBootsModel;
import net.satisfy.candlelight.client.model.CookingChestplateModel;
import net.satisfy.candlelight.client.model.CookingHatModel;
import net.satisfy.candlelight.client.model.CookingLeggingsModel;
import net.satisfy.candlelight.client.model.DressChestplateModel;
import net.satisfy.candlelight.client.model.FlowerCrownModel;
import net.satisfy.candlelight.client.model.SuitLeggingsModel;
import net.satisfy.candlelight.client.model.TieModel;
import net.satisfy.candlelight.core.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ArmorRegistry {
    private static final Map<Item, TieModel<?>> TieModels = new HashMap();
    private static final Map<Item, FlowerCrownModel<?>> crownModels = new HashMap();
    private static final Map<Item, CookingHatModel<?>> hatModels = new HashMap();
    private static final Map<Item, CookingChestplateModel<?>> chestplateModels = new HashMap();
    private static final Map<Item, CookingLeggingsModel<?>> leggingsModels = new HashMap();
    private static final Map<Item, CookingBootsModel<?>> bootsModels = new HashMap();
    private static final Map<Item, DressChestplateModel<?>> dressModels = new HashMap();
    private static final Map<Item, SuitLeggingsModel<?>> suitModels = new HashMap();

    public static Model getHatModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        CookingHatModel model = hatModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.COOKING_HAT.get()) {
                return new CookingHatModel(modelSet.m_171103_(CookingHatModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead);
        }
        return model;
    }

    public static Model getCrownModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        FlowerCrownModel model = crownModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.FLOWER_CROWN.get()) {
                return new FlowerCrownModel(modelSet.m_171103_(FlowerCrownModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead);
        }
        return model;
    }

    public static Model getTieModel(Item item, ModelPart baseHead, ModelPart baseBody) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        TieModel model = TieModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.NECKTIE.get()) {
                return new TieModel(modelSet.m_171103_(TieModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead, baseBody);
        }
        return model;
    }

    public static Model getChestplateModel(Item item, ModelPart body, ModelPart leftArm, ModelPart rightArm, ModelPart leftLeg, ModelPart rightLeg) {
        CookingChestplateModel model = chestplateModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.CHEFS_JACKET.get() || key == ObjectRegistry.FORMAL_SHIRT.get() || key == ObjectRegistry.SHIRT.get()) {
                return new CookingChestplateModel(Minecraft.m_91087_().m_167973_().m_171103_(CookingChestplateModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyBody(body, leftArm, rightArm, leftLeg, rightLeg);
        }
        return model;
    }

    public static Model getDressModel(Item item, ModelPart body, ModelPart leftArm, ModelPart rightArm, ModelPart leftLeg, ModelPart rightLeg) {
        DressChestplateModel model = dressModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.DRESS.get()) {
                return new DressChestplateModel(Minecraft.m_91087_().m_167973_().m_171103_(DressChestplateModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyBody(body, leftArm, rightArm, leftLeg, rightLeg);
        }
        return model;
    }

    public static Model getLeggingsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        CookingLeggingsModel model = leggingsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.CHEFS_PANTS.get() || key == ObjectRegistry.TROUSERS_AND_VEST.get()) {
                return new CookingLeggingsModel(Minecraft.m_91087_().m_167973_().m_171103_(CookingLeggingsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static Model getSuitModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        SuitLeggingsModel model = suitModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.CHEFS_PANTS.get() || key == ObjectRegistry.TROUSERS_AND_VEST.get()) {
                return new SuitLeggingsModel(Minecraft.m_91087_().m_167973_().m_171103_(SuitLeggingsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static Model getBootsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        CookingBootsModel model = bootsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.CHEFS_BOOTS.get()) {
                return new CookingBootsModel(Minecraft.m_91087_().m_167973_().m_171103_(CookingBootsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }
}

