/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.core.block.CStoveBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class BambooStoveBlock
extends CStoveBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.8125, (double)0.1875, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)1.0, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });

    public BambooStoveBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (double)pos.m_123342_() + 0.24;
            double f = (double)pos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.1) {
                world.m_7785_(d, e, f, SoundEvents.f_11784_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            world.m_7785_(d, e, f, SoundEvents.f_12472_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            world.m_7785_(d, e, f, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            for (Direction direction : Direction.values()) {
                if (direction == Direction.DOWN || direction == state.m_61143_((Property)FACING)) continue;
                Direction.Axis axis = direction.m_122434_();
                double h = random.m_188500_() * 0.6 - 0.3;
                double i = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : h;
                double j = random.m_188500_() * 6.0 / 16.0;
                double k = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : h;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
            }
            double particleHeight = (double)pos.m_123342_() + 0.5 + 1.0;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, particleHeight, f, 0.0, 0.0, 0.0);
        }
    }
}

