/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.util;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.camping.platform.PlatformHelper;

public class CampingUtil {
    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = CampingUtil.registerWithoutItem(registerB, registrarB, name, block);
        CampingUtil.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static class Grilling {
        private static final String GRILLED_KEY = "Grilled";
        private static final String NUTRITION_KEY = "GrilledNutrition";
        private static final String SATURATION_KEY = "GrilledSaturation";

        public static boolean isGrilled(ItemStack itemStack) {
            return itemStack.m_41782_() && Objects.requireNonNull(itemStack.m_41783_()).m_128441_(GRILLED_KEY);
        }

        public static void setGrilled(ItemStack itemStack) {
            PlatformHelper.setGrilled(itemStack);
        }

        public static void increaseFoodValue(ItemStack itemStack) {
            FoodProperties food = itemStack.m_41720_().m_41473_();
            if (food != null) {
                int newNutrition = (int)((double)food.m_38744_() * 1.25);
                float newSaturation = food.m_38745_() * 1.25f;
                CompoundTag tag = itemStack.m_41784_();
                tag.m_128405_(NUTRITION_KEY, newNutrition);
                tag.m_128350_(SATURATION_KEY, newSaturation);
            }
        }

        public static FoodValue getAdditionalFoodValue(ItemStack itemStack) {
            CompoundTag tag = itemStack.m_41783_();
            if (tag != null && tag.m_128441_(NUTRITION_KEY) && tag.m_128441_(SATURATION_KEY)) {
                int nutrition = tag.m_128451_(NUTRITION_KEY);
                float saturation = tag.m_128457_(SATURATION_KEY);
                return new FoodValue(nutrition, saturation);
            }
            return new FoodValue(0, 0.0f);
        }

        public static void addGrilledTooltip(ItemStack itemStack, List<Component> tooltip) {
            if (Grilling.isGrilled(itemStack)) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.camping.grilled").m_130940_(ChatFormatting.GOLD));
                FoodValue value = Grilling.getAdditionalFoodValue(itemStack);
                tooltip.add((Component)Component.m_237110_((String)"tooltip.camping.grilled.nutrition", (Object[])new Object[]{value.nutrition()}).m_130940_(ChatFormatting.GREEN));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.camping.grilled.saturationModifier", (Object[])new Object[]{Float.valueOf(value.saturationModifier())}).m_130940_(ChatFormatting.GREEN));
            }
        }

        public record FoodValue(int nutrition, float saturationModifier) {
            @Override
            public String toString() {
                return "{Nutrition:" + this.nutrition + ",Saturation:" + this.saturationModifier + "}";
            }
        }
    }
}

