/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.registry;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.netty.buffer.Unpooled;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.camping.item.BackpackItem;
import net.satisfy.camping.item.EnderpackItem;
import net.satisfy.camping.network.OpenBackpackPacket;
import net.satisfy.camping.network.PacketHandler;
import net.satisfy.camping.platform.PlatformHelper;

@OnlyIn(value=Dist.CLIENT)
public class KeyHandlerRegistry {
    private static final String CATEGORY = "key.camping.category";
    private static final String OPEN_KEY = "key.camping.open";
    private static final KeyMapping open_key = new KeyMapping("key.camping.open", InputConstants.Type.KEYSYM, 66, "key.camping.category");

    public static void init() {
        KeyMappingRegistry.register((KeyMapping)open_key);
        KeyHandlerRegistry.registerKeyHandler();
    }

    private static void registerKeyHandler() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            LocalPlayer player;
            if (open_key.m_90859_() && (player = client.f_91074_) != null) {
                if (PlatformHelper.isBackpackEquipped((Player)player)) {
                    ItemStack backpackItem = PlatformHelper.getEquippedBackpack((Player)player);
                    if (!backpackItem.m_41619_()) {
                        if (backpackItem.m_41720_() instanceof BackpackItem) {
                            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                            new OpenBackpackPacket(backpackItem).toBytes(buf);
                            NetworkManager.sendToServer((ResourceLocation)OpenBackpackPacket.ID, (FriendlyByteBuf)buf);
                        } else if (backpackItem.m_41720_() instanceof EnderpackItem) {
                            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                            NetworkManager.sendToServer((ResourceLocation)PacketHandler.OPEN_ENDER_CHEST_PACKET_ID, (FriendlyByteBuf)buf);
                        }
                    }
                } else {
                    NetworkManager.sendToServer((ResourceLocation)PacketHandler.OPEN_ENDER_CHEST_PACKET_ID, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
                }
            }
        });
    }
}

