/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.network;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.camping.client.screen.BackpackScreenHandler;
import net.satisfy.camping.inventory.BackpackContainer;
import net.satisfy.camping.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class OpenBackpackPacket {
    public static final ResourceLocation ID = new ResourceLocation("camping", "open_backpack");
    private final ItemStack backpackItem;

    public OpenBackpackPacket(ItemStack backpackItem) {
        this.backpackItem = backpackItem;
    }

    public OpenBackpackPacket(FriendlyByteBuf buf) {
        this.backpackItem = buf.m_130267_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.backpackItem);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        Player player = contextSupplier.get().getPlayer();
        Level level = contextSupplier.get().getPlayer().m_9236_();
        ItemStack itemStack = PlatformHelper.getEquippedBackpack(player);
        if (level.m_5776_()) {
            return;
        }
        CompoundTag blockEntityTag = BlockItem.m_186336_((ItemStack)itemStack);
        if (blockEntityTag != null) {
            if (blockEntityTag.m_128425_("Items", 9)) {
                final NonNullList itemStacks = NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)blockEntityTag, (NonNullList)itemStacks);
                player.m_5893_((MenuProvider)new SimpleMenuProvider(new MenuConstructor(){

                    @NotNull
                    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                        return new BackpackScreenHandler(i, player.m_150109_(), new BackpackContainer((NonNullList<ItemStack>)itemStacks, player));
                    }
                }, (Component)Component.m_237115_((String)"container.camping.backpack")));
            }
        } else {
            CompoundTag compoundTag = new CompoundTag();
            ContainerHelper.m_18973_((CompoundTag)compoundTag, (NonNullList)NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_));
            itemStack.m_41700_("BlockEntityTag", (Tag)compoundTag);
            final NonNullList itemStacks = NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_);
            blockEntityTag = BlockItem.m_186336_((ItemStack)itemStack);
            ContainerHelper.m_18980_((CompoundTag)blockEntityTag, (NonNullList)itemStacks);
            player.m_5893_((MenuProvider)new SimpleMenuProvider(new MenuConstructor(){

                @NotNull
                public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                    return new BackpackScreenHandler(i, player.m_150109_(), new BackpackContainer((NonNullList<ItemStack>)itemStacks, player));
                }
            }, (Component)Component.m_237115_((String)"container.camping.backpack")));
        }
    }

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ID, (buf, contextSupplier) -> {
            OpenBackpackPacket packet = new OpenBackpackPacket(buf);
            packet.handle(() -> contextSupplier);
        });
    }
}

