/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultitoolItem
extends Item {
    public MultitoolItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Property<?> facingProperty;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (player != null && (facingProperty = this.getFacingProperty(state)) instanceof DirectionProperty) {
            DirectionProperty directionProperty = (DirectionProperty)facingProperty;
            BlockState rotatedState = this.rotateBlock(state, directionProperty);
            level.m_7731_(pos, rotatedState, 3);
            this.spawnBlockParticles(level, pos, rotatedState);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Property<?> getFacingProperty(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return BlockStateProperties.f_61372_;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return BlockStateProperties.f_61374_;
        }
        return null;
    }

    private BlockState rotateBlock(BlockState state, DirectionProperty property) {
        return (BlockState)state.m_61124_((Property)property, (Comparable)((Direction)state.m_61143_((Property)property)).m_122427_());
    }

    private void spawnBlockParticles(Level level, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            double x = (double)pos.m_123341_() + 0.5 + 0.5 * (double)direction.m_122429_();
            double y = (double)pos.m_123342_() + 0.5 + 0.5 * (double)direction.m_122430_();
            double z = (double)pos.m_123343_() + 0.5 + 0.5 * (double)direction.m_122431_();
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), x, y, z, (double)direction.m_122429_() * 0.1, (double)direction.m_122430_() * 0.1, (double)direction.m_122431_() * 0.1);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.camping.multitool").m_130940_(ChatFormatting.WHITE));
    }
}

