/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.forge.client.renderer.player.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.satisfy.camping.client.model.LargeBackpackModel;
import net.satisfy.camping.forge.client.CampingClientForge;
import net.satisfy.camping.util.CampingIdentifier;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class CuriosLargeBackpackLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final LargeBackpackModel<T> model = new LargeBackpackModel(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.LARGE_BACKPACK_LAYER));

    public CuriosLargeBackpackLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean shouldRender = false;
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (!stack.m_41720_().m_5524_().toLowerCase().contains("large_backpack")) continue;
            shouldRender = true;
            break;
        }
        if (!shouldRender) {
            shouldRender = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).map(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!stack.m_41720_().m_5524_().toLowerCase().contains("large_backpack")) continue;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        if (shouldRender) {
            this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, -1.4f, 0.025f);
            CuriosLargeBackpackLayer.m_117376_(this.model, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)light, entity, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    @NotNull
    protected CampingIdentifier getTextureLocation(@NotNull T entity) {
        return new CampingIdentifier("textures/model/large_backpack.png");
    }
}

