/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.event;

import dev.architectury.event.events.common.LootEvent;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    public static void registerEvents() {
        LootEvent.MODIFY_LOOT_TABLE.register(CommonEvents::onModifyLootTable);
    }

    public static void onModifyLootTable(@Nullable LootDataManager lootDataManager, ResourceLocation id, LootEvent.LootTableModificationContext ctx, boolean b) {
        LoottableInjector.InjectLoot(id, ctx);
    }

    public static class LoottableInjector {
        public static void InjectLoot(ResourceLocation id, LootEvent.LootTableModificationContext context) {
            String prefix = "minecraft:chests/";
            String name = id.toString();
            if (name.startsWith(prefix)) {
                String file = name.substring(name.indexOf(prefix) + prefix.length());
                HashSet<String> validFiles = new HashSet<String>(Arrays.asList("end_city_treasure", "stronghold_corridor", "stronghold_crossing", "stronghold_library", "spawn_bonus_chest"));
                if (validFiles.contains(file)) {
                    context.addPool(LoottableInjector.getPool(file));
                }
            }
        }

        public static LootPool getPool(String entryName) {
            return LootPool.m_79043_().m_79076_(LoottableInjector.getPoolEntry(entryName)).m_79082_();
        }

        private static LootPoolEntryContainer.Builder getPoolEntry(String name) {
            ResourceLocation table = new ResourceLocation("camping", "chests/" + name);
            return LootTableReference.m_79776_((ResourceLocation)table);
        }
    }
}

