/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.camping.block.GrillBlock;
import net.satisfy.camping.registry.EntityTypeRegistry;
import net.satisfy.camping.util.CampingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrillBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];
    private final RecipeManager.CachedCheck<Container, CampfireCookingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.GRILL_BLOCK_ENTITY.get(), pos, state);
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        boolean hasItems = false;
        for (int i = 0; i < grill.items.size(); ++i) {
            SimpleContainer container;
            ItemStack result;
            ItemStack itemStack = (ItemStack)grill.items.get(i);
            if (itemStack.m_41619_()) continue;
            hasItems = true;
            int n = i;
            grill.cookingProgress[n] = grill.cookingProgress[n] + 1;
            if (grill.cookingProgress[i] < grill.cookingTime[i] || !(result = grill.quickCheck.m_213657_((Container)(container = new SimpleContainer(new ItemStack[]{itemStack})), level).map(arg_0 -> GrillBlockEntity.lambda$cookTick$0((Container)container, level, arg_0)).orElse(itemStack)).m_246617_(level.m_246046_())) continue;
            CampingUtil.Grilling.setGrilled(result);
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)result);
            grill.items.set(i, (Object)ItemStack.f_41583_);
            level.m_7260_(pos, state, state, 3);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
        }
        if (hasItems) {
            GrillBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            level.m_5594_(null, pos, SoundEvents.f_12472_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        int i;
        RandomSource randomSource = level.f_46441_;
        if (randomSource.m_188501_() < 0.11f) {
            for (i = 0; i < randomSource.m_188503_(2) + 2; ++i) {
                GrillBlockEntity.makeParticles(level, pos);
            }
        }
        i = ((Direction)state.m_61143_((Property)GrillBlock.FACING)).m_122416_();
        for (int j = 0; j < grill.items.size(); ++j) {
            if (((ItemStack)grill.items.get(j)).m_41619_() || !(randomSource.m_188501_() < 0.2f)) continue;
            Direction direction = Direction.m_122407_((int)Math.floorMod(j + i, 4));
            float offset = 0.15625f;
            double d = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * offset) + (double)((float)direction.m_122427_().m_122429_() * offset);
            double e = (double)pos.m_123342_() + 1.2;
            double g = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * offset) + (double)((float)direction.m_122427_().m_122431_() * offset);
            for (int k = 0; k < 4; ++k) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, g, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private static void makeParticles(Level level, BlockPos pos) {
        RandomSource randomSource = level.f_46441_;
        level.m_6485_((ParticleOptions)ParticleTypes.f_123762_, true, (double)pos.m_123341_() + 0.5 + randomSource.m_188500_() / 3.0 * (double)(randomSource.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 1.3 + randomSource.m_188500_() + randomSource.m_188500_(), (double)pos.m_123343_() + 0.5 + randomSource.m_188500_() / 3.0 * (double)(randomSource.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128425_("CookingTimes", 11)) {
            int[] times = tag.m_128465_("CookingTimes");
            System.arraycopy(times, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, times.length));
        }
        if (tag.m_128425_("CookingTotalTimes", 11)) {
            int[] totalTimes = tag.m_128465_("CookingTotalTimes");
            System.arraycopy(totalTimes, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, totalTimes.length));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
        tag.m_128385_("CookingTimes", this.cookingProgress);
        tag.m_128385_("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundTag, this.items, (boolean)true);
        return compoundTag;
    }

    public Optional<CampfireCookingRecipe> getCookableRecipe(ItemStack stack) {
        return this.items.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
    }

    public boolean placeFood(@Nullable Entity entity, ItemStack stack, int cookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (!itemStack.m_41619_()) continue;
            this.cookingTime[i] = cookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)stack.m_41620_(1));
            assert (this.f_58857_ != null);
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.m_6596_();
        Objects.requireNonNull(this.m_58904_()).m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.items.clear();
    }

    private static /* synthetic */ ItemStack lambda$cookTick$0(Container container, Level level, CampfireCookingRecipe recipe) {
        return recipe.m_5874_(container, level.m_9598_());
    }
}

