/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.camping.block.entity.EnderpackBlockEntity;
import net.satisfy.camping.registry.EntityTypeRegistry;
import net.satisfy.camping.registry.ObjectRegistry;
import net.satisfy.camping.util.CampingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderpackBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final BackpackType backpackType;
    private static final Supplier<VoxelShape> ENDERPACK = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.3125, (double)0.8125, (double)0.625, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.125, (double)0.25, (double)0.6875, (double)0.5, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    private static final Supplier<VoxelShape> ENDERBAG = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.4375, (double)0.8125, (double)0.75, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.5, (double)0.375, (double)0.5625, (double)0.625, (double)0.4375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<BackpackType, Map<Direction, VoxelShape>> SHAPES = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(BackpackType.ENDERPACK, EnderpackBlock.generateShapes(ENDERPACK));
        map.put(BackpackType.ENDERBAG, EnderpackBlock.generateShapes(ENDERBAG));
    });

    public EnderpackBlock(BlockBehaviour.Properties properties, BackpackType backpackType) {
        super(properties);
        this.backpackType = backpackType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)ObjectRegistry.ENDERPACK.get());
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6047_()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, playerEntity) -> ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)player.m_36327_()), (Component)((Block)ObjectRegistry.ENDERPACK.get()).m_49954_()));
            return InteractionResult.SUCCESS;
        }
        level.m_46961_(pos, false);
        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)ObjectRegistry.ENDERPACK.get())));
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 3; ++i) {
            int posMultiplier = random.m_188503_(2) * 2 - 1;
            int speedMultiplier = random.m_188503_(2) * 2 - 1;
            double xPos = (double)pos.m_123341_() + 0.5 + 0.25 * (double)posMultiplier;
            double yPos = (float)pos.m_123342_() + random.m_188501_();
            double zPos = (double)pos.m_123343_() + 0.5 + 0.25 * (double)speedMultiplier;
            double xSpeed = random.m_188501_() * (float)posMultiplier;
            double ySpeed = ((double)random.m_188501_() - 0.5) * 0.125;
            double zSpeed = random.m_188501_() * (float)speedMultiplier;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }

    private static Map<Direction, VoxelShape> generateShapes(Supplier<VoxelShape> shapeSupplier) {
        HashMap<Direction, VoxelShape> shapeMap = new HashMap<Direction, VoxelShape>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            shapeMap.put(direction, CampingUtil.rotateShape(Direction.NORTH, direction, shapeSupplier.get()));
        }
        return shapeMap;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Object)this.backpackType).get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnderpackBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return EnderpackBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.ENDERPACK_BLOCK_ENTITY.get()), (world, pos, state1, blockEntity) -> blockEntity.tick(world, pos, state1, (EnderpackBlockEntity)blockEntity));
    }

    public static enum BackpackType {
        ENDERPACK,
        ENDERBAG;

    }
}

