/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.camping.block.BackpackBlockShapes;
import net.satisfy.camping.block.BackpackType;
import net.satisfy.camping.block.entity.BackpackBlockEntity;
import net.satisfy.camping.registry.ObjectRegistry;
import net.satisfy.camping.util.CampingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final BackpackType backpackType;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    public static final Map<BackpackType, Map<Direction, VoxelShape>> SHAPES = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(BackpackType.SMALL_BACKPACK, BackpackBlock.generateShapes(BackpackBlockShapes.SMALL_BACKPACK));
        map.put(BackpackType.LARGE_BACKPACK, BackpackBlock.generateShapes(BackpackBlockShapes.LARGE_BACKPACK));
        map.put(BackpackType.WANDERER_BACKPACK, BackpackBlock.generateShapes(BackpackBlockShapes.WANDERER_BACKPACK));
        map.put(BackpackType.WANDERER_BAG, BackpackBlock.generateShapes(BackpackBlockShapes.WANDERER_BAG));
        map.put(BackpackType.GOODYBAG, BackpackBlock.generateShapes(BackpackBlockShapes.GOODYBAG));
        map.put(BackpackType.SHEEPBAG, BackpackBlock.generateShapes(BackpackBlockShapes.SHEEPBAG));
    });

    public BackpackBlock(BlockBehaviour.Properties properties, BackpackType backpackType) {
        super(properties);
        this.backpackType = backpackType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            if (player.m_6144_()) {
                level.m_46961_(blockPos, true);
                this.dropBlockWithContents(level, blockPos, backpackBlockEntity);
                return InteractionResult.CONSUME;
            }
            player.m_5893_((MenuProvider)backpackBlockEntity);
            player.m_36220_(Stats.f_12970_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private void dropBlockWithContents(Level level, BlockPos blockPos, BackpackBlockEntity backpackBlockEntity) {
        ItemStack itemStack = new ItemStack((ItemLike)this.getBackpackItem());
        backpackBlockEntity.m_187476_(itemStack);
        if (backpackBlockEntity.m_8077_()) {
            itemStack.m_41714_(backpackBlockEntity.m_7770_());
        }
        ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack);
        itemEntity.m_32060_();
        level.m_7967_((Entity)itemEntity);
    }

    private Item getBackpackItem() {
        return switch (this.getBackpackType()) {
            default -> throw new IncompatibleClassChangeError();
            case BackpackType.WANDERER_BACKPACK -> (Item)ObjectRegistry.WANDERER_BACKPACK_ITEM.get();
            case BackpackType.LARGE_BACKPACK -> (Item)ObjectRegistry.LARGE_BACKPACK_ITEM.get();
            case BackpackType.SMALL_BACKPACK -> (Item)ObjectRegistry.SMALL_BACKPACK_ITEM.get();
            case BackpackType.WANDERER_BAG -> (Item)ObjectRegistry.WANDERER_BAG_ITEM.get();
            case BackpackType.SHEEPBAG -> (Item)ObjectRegistry.SHEEPBAG_ITEM.get();
            case BackpackType.GOODYBAG -> (Item)ObjectRegistry.GOODYBAG_ITEM.get();
        };
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            this.dropBlockWithContents(level, blockPos, backpackBlockEntity);
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack pItemStack) {
        super.m_6240_(level, player, blockPos, blockState, blockEntity, pItemStack);
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            builder = builder.m_287145_(CONTENTS, consumer -> {
                for (int i = 0; i < backpackBlockEntity.m_6643_(); ++i) {
                    consumer.accept(backpackBlockEntity.m_8020_(i));
                }
            });
        }
        return super.m_49635_(blockState, builder);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BackpackBlockEntity(blockPos, blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BackpackType getBackpackType() {
        return this.backpackType;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(blockPos));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static Map<Direction, VoxelShape> generateShapes(Supplier<VoxelShape> shapeSupplier) {
        HashMap<Direction, VoxelShape> shapeMap = new HashMap<Direction, VoxelShape>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            shapeMap.put(direction, CampingUtil.rotateShape(Direction.NORTH, direction, shapeSupplier.get()));
        }
        return shapeMap;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Object)this.backpackType).get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

