/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.placers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class CornFoliagePlacer
extends FoliagePlacer {
    public static final Codec<CornFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> CornFoliagePlacer.createCodec(instance).apply((Applicative)instance, CornFoliagePlacer::new));
    protected final int height;

    protected static <P extends CornFoliagePlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider, Integer> createCodec(RecordCodecBuilder.Instance<P> builder) {
        return CornFoliagePlacer.m_68573_(builder).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(placer -> placer.height));
    }

    public CornFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    @NotNull
    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)PlacerTypesRegistry.CORN_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        for (int y = offset; y >= offset - foliageHeight; --y) {
            int currentRadius = Math.max(Math.min(radius + treeNode.m_68589_() - 1 - y / 2, 3), 0);
            this.m_225628_(world, placer, random, config, treeNode.m_161451_(), currentRadius, y, treeNode.m_68590_());
        }
    }

    public int m_214116_(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (dx == radius && dz == radius && (random.m_188503_(2) == 0 || y == 0)) {
            return true;
        }
        if (y < radius) {
            return (double)random.m_188501_() < 0.2;
        }
        return (double)random.m_188501_() < 0.05;
    }
}

