/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class AspenFoliagePlacer
extends FoliagePlacer {
    public static final Codec<AspenFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> AspenFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)IntProvider.m_146545_((int)0, (int)24).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, AspenFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public AspenFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider height) {
        super(radius, offset);
        this.trunkHeight = height;
    }

    @NotNull
    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)PlacerTypesRegistry.ASPEN_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        int j;
        BlockPos blockPos = attachment.m_161451_();
        int i = 0;
        int l = offset;
        while (l >= offset - 5) {
            j = this.calculateFoliageRadius(i, level, foliageSetter, random, config, attachment, l);
            this.m_225628_(level, foliageSetter, random, config, blockPos, j, l, attachment.m_68590_());
            --l;
            ++i;
        }
        i = 4;
        l = offset - 6;
        while (l >= offset - 10) {
            j = this.calculateFoliageRadius(i, level, foliageSetter, random, config, attachment, l);
            this.m_225628_(level, foliageSetter, random, config, blockPos, j, l, attachment.m_68590_());
            --l;
            --i;
        }
    }

    private int calculateFoliageRadius(int iteration, LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration config, FoliagePlacer.FoliageAttachment attachment, int offset) {
        return switch (iteration) {
            case 1, 3 -> 1;
            case 2, 4 -> {
                this.placeCornShape(level, foliageSetter, random, config, attachment, offset);
                yield 1;
            }
            case 5 -> 2;
            default -> 0;
        };
    }

    private void placeCornShape(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration config, FoliagePlacer.FoliageAttachment attachment, int offset) {
        this.m_225628_(level, foliageSetter, random, config, attachment.m_161451_().m_122012_(), 1, offset, attachment.m_68590_());
        this.m_225628_(level, foliageSetter, random, config, attachment.m_161451_().m_122019_(), 1, offset, attachment.m_68590_());
        this.m_225628_(level, foliageSetter, random, config, attachment.m_161451_().m_122024_(), 1, offset, attachment.m_68590_());
        this.m_225628_(level, foliageSetter, random, config, attachment.m_161451_().m_122029_(), 1, offset, attachment.m_68590_());
    }

    protected boolean m_214203_(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && range > 0;
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return Math.max(4, height - this.trunkHeight.m_214085_(random));
    }
}

