/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class SnowyFirLeavesBlock
extends LeavesBlock {
    public static final BooleanProperty SNOWY = BooleanProperty.m_61465_((String)"snowy");
    public static final BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");

    public SnowyFirLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SNOWY});
    }

    private static boolean shouldBeSnowy(LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50125_);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        FluidState fluidstate = level.m_6425_(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(SnowyFirLeavesBlock.shouldBeSnowy((LevelReader)level, pos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int newDistance = this.updateDistance((Level)world, pos);
        boolean newSnowy = SnowyFirLeavesBlock.shouldBeSnowy((LevelReader)world, pos);
        if (newDistance >= 7 && !((Boolean)state.m_61143_((Property)f_54419_)).booleanValue() && !((Boolean)state.m_61143_((Property)SNOWY)).booleanValue()) {
            world.m_7471_(pos, false);
            return;
        }
        if ((Integer)state.m_61143_((Property)f_54418_) != newDistance || (Boolean)state.m_61143_((Property)SNOWY) != newSnowy) {
            state = (BlockState)((BlockState)state.m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(newDistance))).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(newSnowy));
            world.m_7731_(pos, state, 3);
        }
        if (!((Boolean)state.m_61143_((Property)f_54419_)).booleanValue()) {
            world.m_186460_(pos, (Block)this, 0);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (direction == Direction.UP && (Boolean)state.m_61143_((Property)SNOWY) != SnowyFirLeavesBlock.shouldBeSnowy((LevelReader)world, pos)) {
            state = (BlockState)state.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(SnowyFirLeavesBlock.shouldBeSnowy((LevelReader)world, pos)));
        }
        if (!((Boolean)state.m_61143_((Property)f_54419_)).booleanValue()) {
            world.m_186460_(pos, (Block)this, 0);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private int updateDistance(Level world, BlockPos pos) {
        int minDistance = 7;
        for (BlockPos neighborPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
            int candidate;
            BlockState neighborState = world.m_8055_(neighborPos);
            if (neighborState.m_204336_(BlockTags.f_13106_)) {
                return 1;
            }
            if (!(neighborState.m_60734_() instanceof LeavesBlock) || !neighborState.m_61138_((Property)f_54418_) || (candidate = (Integer)neighborState.m_61143_((Property)f_54418_) + 1) >= minDistance || (minDistance = candidate) != 1) continue;
            break;
        }
        return minDistance;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

